/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0010;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionCompatibilityService;
import org.eclipse.sapphire.VersionCompatibilityTargetService;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.services.t0010.ChildElement;
import org.eclipse.sapphire.tests.services.t0010.RootElement;
import org.eclipse.sapphire.tests.services.t0010.TestVersionCompatibilityService;
import org.junit.Test;

public final class TestServices0010
extends SapphireTestCase {
    @Test
    public void testVersionCompatibility() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        VersionCompatibilityTargetService rootContextVersionService = (VersionCompatibilityTargetService)root.service(VersionCompatibilityTargetService.class);
        TestServices0010.assertNotNull((Object)rootContextVersionService);
        TestServices0010.assertNull((Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
        root.setVersion("1.0");
        TestServices0010.assertEquals((Object)new Version("1.0"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
        root.setVersion("1.2");
        TestServices0010.assertEquals((Object)new Version("1.2"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
        root.setVersion("1.2.3");
        TestServices0010.assertEquals((Object)new Version("1.2.3"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, true);
    }

    @Test
    public void testDynamicVersionCompatibility() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        VersionCompatibilityTargetService rootContextVersionService = (VersionCompatibilityTargetService)root.service(VersionCompatibilityTargetService.class);
        TestServices0010.assertNotNull((Object)rootContextVersionService);
        TestServices0010.assertNull((Object)rootContextVersionService.version());
        root.setVersion("1.2.5");
        TestServices0010.assertEquals((Object)new Version("1.2.5"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, true);
        root.setSwitch(true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, false);
    }

    @Test
    public void testCustomVersionCompatibilityService() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        VersionCompatibilityTargetService rootContextVersionService = (VersionCompatibilityTargetService)root.service(VersionCompatibilityTargetService.class);
        TestServices0010.assertNotNull((Object)rootContextVersionService);
        TestServices0010.assertNull((Object)rootContextVersionService.version());
        TestVersionCompatibilityService service = (TestVersionCompatibilityService)root.property(RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE).service(VersionCompatibilityService.class);
        TestServices0010.assertNotNull((Object)((Object)service));
        root.setVersion("2.0");
        TestServices0010.assertEquals((Object)new Version("2.0"), (Object)rootContextVersionService.version());
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, true);
        service.update("3.0");
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, false);
        service.update("1.0");
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_SERVICE, true);
    }

    @Test
    public void testCascadingVersionCompatibility() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        ChildElement elementPropertyChild = (ChildElement)root.getChild().content(true);
        ChildElement impliedElementPropertyChild = root.getChildImplied();
        ChildElement listElementChild1 = (ChildElement)root.getChildren().insert();
        ChildElement listElementChild2 = (ChildElement)root.getChildren().insert();
        root.setVersion("1.0");
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILD, false);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILD_IMPLIED, false);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILDREN, false);
        TestServices0010.assertVersionCompatibility(listElementChild1, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(listElementChild1, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(listElementChild2, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, false);
        TestServices0010.assertVersionCompatibility(listElementChild2, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        root.setVersion("2.0");
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILD, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILD_IMPLIED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILDREN, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        TestServices0010.assertVersionCompatibility(listElementChild2, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild2, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        ChildElement listElementChild3 = (ChildElement)root.getChildren().insert();
        TestServices0010.assertVersionCompatibility(listElementChild3, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild3, (PropertyDef)ChildElement.PROP_VALUE_SINCE, false);
        root.setVersion("3.0");
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILD, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(elementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILD_IMPLIED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(impliedElementPropertyChild, (PropertyDef)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(root, (PropertyDef)RootElement.PROP_CHILDREN, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild1, (PropertyDef)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(listElementChild2, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild2, (PropertyDef)ChildElement.PROP_VALUE_SINCE, true);
        TestServices0010.assertVersionCompatibility(listElementChild3, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild3, (PropertyDef)ChildElement.PROP_VALUE_SINCE, true);
        ChildElement listElementChild4 = (ChildElement)root.getChildren().insert();
        TestServices0010.assertVersionCompatibility(listElementChild4, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, true);
        TestServices0010.assertVersionCompatibility(listElementChild4, (PropertyDef)ChildElement.PROP_VALUE_SINCE, true);
    }

    @Test
    public void testVersionCompatibilityValidationServiceForValue() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertValidationOk(root.getValueSince());
        root.setValueSince("abc");
        TestServices0010.assertValidationError(root.getValueSince(), "Version constraint exists, but no version constraint target was found");
        root.setValueSince(null);
        root.setVersion("1.0");
        TestServices0010.assertValidationOk(root.getValueSince());
        root.setValueSince("abc");
        TestServices0010.assertValidationError(root.getValueSince(), "Not compatible with version 1 of Test Versioned System");
        root.setValueSince(null);
        TestServices0010.assertValidationOk(root.getValueSince());
    }

    @Test
    public void testVersionCompatibilityValidationServiceForElement() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertValidationOk(root.getChild());
        root.getChild().content(true);
        TestServices0010.assertValidationError(root.getChild(), "Version constraint exists, but no version constraint target was found");
        root.getChild().clear();
        root.setVersion("1.0");
        TestServices0010.assertValidationOk(root.getChild());
        root.getChild().content(true);
        TestServices0010.assertValidationError(root.getChild(), "Not compatible with version 1 of Test Versioned System");
        root.getChild().clear();
        TestServices0010.assertValidationOk(root.getChild());
    }

    @Test
    public void testVersionCompatibilityValidationServiceForList() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        TestServices0010.assertValidationOk(root.getChildren());
        root.getChildren().insert();
        TestServices0010.assertValidationError(root.getChildren(), "Version constraint exists, but no version constraint target was found");
        root.getChildren().remove(0);
        root.setVersion("1.0");
        TestServices0010.assertValidationOk(root.getChildren());
        root.getChildren().insert();
        TestServices0010.assertValidationError(root.getChildren(), "Not compatible with version 1 of Test Versioned System");
        root.getChildren().remove(0);
        TestServices0010.assertValidationOk(root.getChildren());
    }

    @Test
    public void testVersionCompatibilityEnablementServiceForValue() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        Value property = root.property(RootElement.PROP_VALUE_SINCE);
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
    }

    @Test
    public void testVersionCompatibilityEnablementServiceForElement() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        ElementHandle property = root.property(RootElement.PROP_CHILD);
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
    }

    @Test
    public void testVersionCompatibilityEnablementServiceForElementImplied() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        ElementHandle property = root.property((ElementProperty)RootElement.PROP_CHILD_IMPLIED);
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
    }

    @Test
    public void testVersionCompatibilityEnablementServiceForList() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        ElementList property = root.property(RootElement.PROP_CHILDREN);
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
        root.setVersion("3.0");
        TestServices0010.assertTrue((boolean)property.enabled());
        root.setVersion("1.0");
        TestServices0010.assertFalse((boolean)property.enabled());
    }

    @Test
    public void testVersionCompatibilityFactsService() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        root.setVersion("1.0");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_SINCE, "Since Test Versioned System 1.2");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, "Since Test Versioned System 1.2");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, "For Test Versioned System [1.2.3-1.3)");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, "For Test Versioned System [1.2.3-1.3)");
        root.setSwitch(true);
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_SINCE, "Since Test Versioned System 1.2");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_SINCE_DYNAMIC, "Since Test Versioned System 2");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY, "For Test Versioned System [1.2.3-1.3)");
        TestServices0010.assertFact(root, (PropertyDef)RootElement.PROP_VALUE_VERSION_COMPATIBILITY_DYNAMIC, "Since Test Versioned System 2");
        ChildElement child = root.getChildImplied();
        TestServices0010.assertFact(child, (PropertyDef)ChildElement.PROP_VALUE_UNCONSTRAINED, "Since Test Versioned System 2");
        TestServices0010.assertFact(child, (PropertyDef)ChildElement.PROP_VALUE_SINCE, "Since Test Versioned System 3");
    }

    private static void assertVersionCompatibility(Element element, PropertyDef property, boolean expectedVersionCompatibility) {
        MasterVersionCompatibilityService service = (MasterVersionCompatibilityService)element.property(property).service(MasterVersionCompatibilityService.class);
        TestServices0010.assertNotNull((Object)service);
        TestServices0010.assertEquals((Object)expectedVersionCompatibility, (Object)service.compatible());
    }
}

