/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.diagram.editor.ContainerShapePart;
import org.eclipse.sapphire.ui.diagram.editor.RectanglePart;
import org.eclipse.sapphire.ui.diagram.shape.def.BackgroundDef;
import org.eclipse.sapphire.ui.diagram.shape.def.BorderComponent;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutConstraintDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutOrientation;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeLayoutDef;
import org.eclipse.sapphire.ui.swt.gef.figures.RectangleFigure;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireSequenceLayoutConstraint;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireStackLayoutConstraint;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapeFactoryPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class RectanglePresentation
extends ContainerShapePresentation {
    public RectanglePresentation(DiagramPresentation parent, RectanglePart rectanglePart, DiagramResourceCache resourceCache) {
        super(parent, (ContainerShapePart)rectanglePart, resourceCache);
    }

    public RectanglePart part() {
        return (RectanglePart)super.part();
    }

    public BackgroundDef getBackground() {
        return this.part().getBackground();
    }

    public int getCornerRadius() {
        return this.part().getCornerRadius();
    }

    public BorderComponent getTopBorder() {
        return this.part().getTopBorder();
    }

    public BorderComponent getBottomBorder() {
        return this.part().getBottomBorder();
    }

    public BorderComponent getLeftBorder() {
        return this.part().getLeftBorder();
    }

    public BorderComponent getRightBorder() {
        return this.part().getRightBorder();
    }

    @Override
    public void render() {
        RectangleFigure figure = new RectangleFigure(this, this.getResourceCache(), this.getConfigurationManager());
        ShapeLayoutDef layoutDef = this.getLayout();
        for (ShapePresentation childShapePresentation : this.getChildren()) {
            if (!(childShapePresentation instanceof ContainerShapePresentation) && !childShapePresentation.part().isActive()) {
                childShapePresentation.render();
                IFigure childFigure = childShapePresentation.getFigure();
                if (childFigure != null) {
                    Object layoutConstraint = this.getLayoutConstraint(childShapePresentation, layoutDef);
                    if (layoutConstraint != null) {
                        figure.add(childFigure, layoutConstraint);
                    } else {
                        figure.add(childFigure);
                    }
                }
            }
            if (!(childShapePresentation instanceof ShapeFactoryPresentation)) continue;
            ShapeFactoryPresentation shapeFactoryPresentation = (ShapeFactoryPresentation)childShapePresentation;
            shapeFactoryPresentation.setIndex(figure.getChildren().size());
        }
        this.setFigure((IFigure)figure);
    }

    private Object getLayoutConstraint(ShapePresentation childShapePresentation, ShapeLayoutDef layoutDef) {
        Object layoutConstraint = null;
        if (layoutDef instanceof SequenceLayoutDef) {
            if (((SequenceLayoutDef)layoutDef).getOrientation().content() != SequenceLayoutOrientation.STACKED) {
                SequenceLayoutConstraintDef def = (SequenceLayoutConstraintDef)childShapePresentation.getLayoutConstraint();
                layoutConstraint = new SapphireSequenceLayoutConstraint(def);
            } else {
                SequenceLayoutConstraintDef constraintDef;
                SapphireStackLayoutConstraint constraint = null;
                if (childShapePresentation.getLayoutConstraint() != null && (constraintDef = (SequenceLayoutConstraintDef)childShapePresentation.getLayoutConstraint()) != null) {
                    constraint = new SapphireStackLayoutConstraint((HorizontalAlignment)constraintDef.getHorizontalAlignment().content(), (VerticalAlignment)constraintDef.getVerticalAlignment().content(), (Integer)constraintDef.getMarginTop().content(), (Integer)constraintDef.getMarginBottom().content(), (Integer)constraintDef.getMarginLeft().content(), (Integer)constraintDef.getMarginRight().content());
                }
                layoutConstraint = constraint != null ? constraint : new SapphireStackLayoutConstraint();
            }
        }
        return layoutConstraint;
    }
}

