/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.samples.calendar.ICalendar;
import org.eclipse.sapphire.samples.calendar.integrated.internal.CalendarResource;
import org.eclipse.sapphire.samples.contacts.ContactRepository;
import org.eclipse.sapphire.ui.CorruptedResourceExceptionInterceptorImpl;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public final class CalendarEditor
extends SapphireEditor {
    private static final String PAGE_CONTACTS = "Contacts";
    private static final String PAGE_CALENDAR = "Calendar";
    @Text(value="Contacts")
    private static LocalizableText contactsPageName;
    private StructuredTextEditor calendarSourceEditor;
    private StructuredTextEditor contactsSourceEditor;
    private ICalendar modelCalendar;
    private org.eclipse.sapphire.samples.calendar.integrated.ICalendar modelCalendarIntegrated;
    private ContactRepository modelContacts;
    private MasterDetailsEditorPage calendarDesignPage;
    private MasterDetailsEditorPage contactsDesignPage;

    static {
        LocalizableText.init(CalendarEditor.class);
    }

    protected void createEditorPages() throws PartInitException {
        this.addDeferredPage(PAGE_CALENDAR, PAGE_CALENDAR);
        this.addDeferredPage(PAGE_CONTACTS, PAGE_CONTACTS);
        this.calendarSourceEditor = new StructuredTextEditor();
        this.calendarSourceEditor.setEditorPart((IEditorPart)this);
        FileEditorInput rootEditorInput = (FileEditorInput)this.getEditorInput();
        int index = this.addPage((IEditorPart)this.calendarSourceEditor, (IEditorInput)rootEditorInput);
        this.setPageText(index, "calendar.xml");
        this.contactsSourceEditor = new StructuredTextEditor();
        this.contactsSourceEditor.setEditorPart((IEditorPart)this);
        IFile contactsFile = rootEditorInput.getFile().getParent().getFile((IPath)new Path("contacts.xml"));
        index = this.addPage((IEditorPart)this.contactsSourceEditor, (IEditorInput)new FileEditorInput(contactsFile));
        this.setPageText(index, "contacts.xml");
    }

    protected Element createModel() {
        this.modelCalendar = (ICalendar)ICalendar.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.calendarSourceEditor)));
        this.modelContacts = (ContactRepository)ContactRepository.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.contactsSourceEditor)));
        this.modelCalendarIntegrated = (org.eclipse.sapphire.samples.calendar.integrated.ICalendar)org.eclipse.sapphire.samples.calendar.integrated.ICalendar.TYPE.instantiate((Resource)new CalendarResource(this.modelCalendar, this.modelContacts));
        return this.modelCalendarIntegrated;
    }

    protected void adaptModel(Element model) {
        CorruptedResourceExceptionInterceptorImpl interceptor = new CorruptedResourceExceptionInterceptorImpl(this.getEditorSite().getShell());
        this.modelCalendar.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
        this.modelContacts.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
    }

    protected DefinitionLoader.Reference<EditorPageDef> getDefinition(String pageDefinitionId) {
        if (PAGE_CALENDAR.equals(pageDefinitionId)) {
            return DefinitionLoader.sdef(((Object)((Object)this)).getClass()).page();
        }
        if (PAGE_CONTACTS.equals(pageDefinitionId)) {
            return DefinitionLoader.context(ContactRepository.class).sdef("ContactRepositoryEditor").page();
        }
        return null;
    }

    protected IEditorPart createPage(String pageDefinitionId) {
        if (PAGE_CALENDAR.equals(pageDefinitionId)) {
            this.calendarDesignPage = new MasterDetailsEditorPage((SapphireEditor)this, this.getModelElement(), this.getDefinition(pageDefinitionId));
            return this.calendarDesignPage;
        }
        if (PAGE_CONTACTS.equals(pageDefinitionId)) {
            this.getModelElement();
            this.contactsDesignPage = new MasterDetailsEditorPage((SapphireEditor)this, (Element)this.modelContacts, this.getDefinition(pageDefinitionId));
            return this.contactsDesignPage;
        }
        return null;
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page == this.calendarSourceEditor) {
            return (IContentOutlinePage)this.calendarSourceEditor.getAdapter(IContentOutlinePage.class);
        }
        if (page == this.contactsSourceEditor) {
            return (IContentOutlinePage)this.contactsSourceEditor.getAdapter(IContentOutlinePage.class);
        }
        return super.getContentOutline(page);
    }

    public ICalendar getCalendar() {
        return this.modelCalendar;
    }

    public org.eclipse.sapphire.samples.calendar.integrated.ICalendar getCalendarIntegrated() {
        return this.modelCalendarIntegrated;
    }

    public ContactRepository getContactRepository() {
        return this.modelContacts;
    }
}

