/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.DiagramPaletteCompartmentConstants;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramPaletteCompartmentDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.swt.gef.ConnectionCreationFactory;
import org.eclipse.sapphire.ui.swt.gef.DiagramPaletteDrawer;
import org.eclipse.sapphire.ui.swt.gef.NodeCreationFactory;
import org.eclipse.sapphire.ui.swt.gef.internal.SapphireConnectionCreationToolEntry;

public class SapphirePaletteRoot
extends PaletteRoot {
    private SapphireDiagramEditorPagePart diagramPart;

    public SapphirePaletteRoot(SapphireDiagramEditorPagePart diagramPart) {
        this.diagramPart = diagramPart;
        this.updatePaletteEntries();
    }

    public void updatePaletteEntries() {
        List<SapphireConnectionCreationToolEntry> list;
        DiagramPaletteDrawer drawer;
        SapphireConnectionCreationToolEntry tool;
        String tpDesc;
        String tpLabel;
        Object factory;
        Object largeImage;
        this.setDefaultEntry(null);
        ArrayList allEntries = new ArrayList(this.getChildren());
        for (PaletteEntry entry : allEntries) {
            this.remove(entry);
        }
        DiagramEditorPageDef diagramPageDef = (DiagramEditorPageDef)this.diagramPart.definition();
        List nodeTemplates = this.diagramPart.getVisibleNodeTemplates();
        if (nodeTemplates.isEmpty()) {
            return;
        }
        ArrayList<DiagramPaletteDrawer> drawers = new ArrayList<DiagramPaletteDrawer>();
        HashMap entries = new HashMap();
        ElementList compartmentDefs = diagramPageDef.getPaletteCompartments();
        if (compartmentDefs.size() == 0) {
            String label = LabelTransformer.transform((String)DiagramPaletteCompartmentConstants.CONNECTIONS_COMPARTMENT_LABEL, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            DiagramPaletteDrawer connectionDrawer = new DiagramPaletteDrawer(label, "Sapphire.Diagram.Palette.Connections");
            drawers.add(connectionDrawer);
            String label2 = LabelTransformer.transform((String)DiagramPaletteCompartmentConstants.NODES_COMPARTMENT_LABEL, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            DiagramPaletteDrawer nodesDrawer = new DiagramPaletteDrawer(label2, "Sapphire.Diagram.Palette.Nodes");
            drawers.add(nodesDrawer);
        } else {
            for (IDiagramPaletteCompartmentDef compartmentDef : compartmentDefs) {
                String label = LabelTransformer.transform((String)((String)compartmentDef.getLabel().content()), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
                DiagramPaletteDrawer drawer2 = new DiagramPaletteDrawer(label, (String)compartmentDef.getId().content());
                drawers.add(drawer2);
            }
        }
        for (SapphireDiagramEditorPagePart.ConnectionPalette connectionPalette : this.diagramPart.getConnectionPalettes()) {
            IDiagramConnectionDef connDef = connectionPalette.getConnectionDef();
            ImageData imageData = connectionPalette.getSmallIcon();
            ImageDescriptor smallImage = SwtUtil.toImageDescriptor((ImageData)imageData);
            ImageData imageData2 = connectionPalette.getLargeIcon();
            largeImage = SwtUtil.toImageDescriptor((ImageData)imageData2);
            factory = new ConnectionCreationFactory(connDef);
            tpLabel = (String)connDef.getToolPaletteLabel().content();
            if (tpLabel != null) {
                tpLabel = IDiagramConnectionDef.PROP_TOOL_PALETTE_LABEL.getLocalizationService().text(tpLabel, CapitalizationType.TITLE_STYLE, false);
            }
            if ((tpDesc = (String)connDef.getToolPaletteDescription().content()) != null) {
                tpDesc = IDiagramConnectionDef.PROP_TOOL_PALETTE_DESCRIPTION.getLocalizationService().text(tpDesc, CapitalizationType.TITLE_STYLE, false);
            }
            if (tpLabel == null) continue;
            tool = new SapphireConnectionCreationToolEntry(tpLabel, tpDesc, (CreationFactory)factory, smallImage, (ImageDescriptor)largeImage);
            drawer = this.getDiagramPaletteDrawer(drawers, (String)connDef.getToolPaletteCompartment().content());
            list = (ArrayList<SapphireConnectionCreationToolEntry>)entries.get(drawer.getId());
            if (list == null) {
                list = new ArrayList<SapphireConnectionCreationToolEntry>();
                entries.put(drawer.getId(), list);
            }
            list.add(tool);
        }
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            IDiagramNodeDef nodeDef = nodeTemplate.definition();
            List imageDatas = nodeTemplate.getToolPaletteImages();
            ArrayList<ImageDescriptor> imageDescriptors = new ArrayList<ImageDescriptor>();
            for (ImageData imageData : imageDatas) {
                imageDescriptors.add(SwtUtil.toImageDescriptor((ImageData)imageData));
            }
            ImageDescriptor smallImage = null;
            largeImage = null;
            if (imageDescriptors.size() == 1) {
                largeImage = (ImageDescriptor)imageDescriptors.get(0);
                smallImage = largeImage;
            } else if (imageDescriptors.size() == 2) {
                org.eclipse.swt.graphics.ImageData id1 = ((ImageDescriptor)imageDescriptors.get(0)).getImageData();
                org.eclipse.swt.graphics.ImageData id2 = ((ImageDescriptor)imageDescriptors.get(1)).getImageData();
                if (id1.width > id2.width || id1.height > id2.height) {
                    smallImage = (ImageDescriptor)imageDescriptors.get(1);
                    largeImage = (ImageDescriptor)imageDescriptors.get(0);
                } else {
                    smallImage = (ImageDescriptor)imageDescriptors.get(0);
                    largeImage = (ImageDescriptor)imageDescriptors.get(1);
                }
            }
            factory = new NodeCreationFactory(nodeTemplate);
            tpLabel = (String)nodeDef.getToolPaletteLabel().content();
            if (tpLabel != null) {
                tpLabel = IDiagramNodeDef.PROP_TOOL_PALETTE_LABEL.getLocalizationService().text(tpLabel, CapitalizationType.TITLE_STYLE, false);
            }
            if ((tpDesc = (String)nodeDef.getToolPaletteDescription().content()) != null) {
                tpDesc = IDiagramNodeDef.PROP_TOOL_PALETTE_DESCRIPTION.getLocalizationService().text(tpDesc, CapitalizationType.TITLE_STYLE, false);
            }
            tool = new CombinedTemplateCreationEntry(tpLabel, tpDesc, (CreationFactory)factory, smallImage, (ImageDescriptor)largeImage);
            tool.setToolClass(CreationTool.class);
            drawer = this.getDiagramPaletteDrawer(drawers, (String)nodeDef.getToolPaletteCompartment().content());
            list = (List)entries.get(drawer.getId());
            if (list == null) {
                list = new ArrayList();
                entries.put(drawer.getId(), list);
            }
            list.add(tool);
        }
        for (DiagramPaletteDrawer drawer3 : drawers) {
            List list2 = (List)entries.get(drawer3.getId());
            if (list2 != null) {
                Collections.sort(list2, new Comparator<ToolEntry>(){

                    @Override
                    public int compare(ToolEntry x, ToolEntry y) {
                        return x.getLabel().compareTo(y.getLabel());
                    }
                });
                drawer3.addAll(list2);
            }
            this.add((PaletteEntry)drawer3);
        }
    }

    private DiagramPaletteDrawer getDiagramPaletteDrawer(List<DiagramPaletteDrawer> drawers, String id) {
        for (DiagramPaletteDrawer drawer : drawers) {
            if (!id.equals(drawer.getId())) continue;
            return drawer;
        }
        return drawers.get(0);
    }
}

