/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionLabelEvent;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.swt.widgets.Shell;

public class DiagramConnectionPresentation
extends DiagramPresentation {
    private Listener connectionListener;

    public DiagramConnectionPresentation(DiagramConnectionPart connPart, DiagramPresentation parent, Shell shell, DiagramConfigurationManager configManager, DiagramResourceCache resourceCache) {
        super((SapphirePart)connPart, parent, configManager, shell);
    }

    public void init(final DiagramConnectionModel diagramConnectionModel) {
        this.connectionListener = new FilteredListener<ConnectionEvent>(){

            protected void handleTypedEvent(ConnectionEvent event) {
                if (event instanceof ConnectionBendpointsEvent) {
                    diagramConnectionModel.handleUpdateBendPoints();
                } else if (event instanceof ConnectionLabelEvent) {
                    ConnectionLabelEvent labelEvent = (ConnectionLabelEvent)event;
                    if (labelEvent.moveLabel()) {
                        diagramConnectionModel.handleUpdateConnectionMoveLabel();
                    } else {
                        diagramConnectionModel.handleUpdateConnection();
                    }
                }
            }
        };
        this.part().attach(this.connectionListener);
    }

    public void dispose() {
        this.part().detach(this.connectionListener);
        super.dispose();
    }

    public DiagramConnectionPart part() {
        return (DiagramConnectionPart)super.part();
    }
}

