/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.layout.standard;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionLabelEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.StandardDiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.internal.StandardEmbeddedConnectionPart;
import org.eclipse.sapphire.ui.diagram.layout.ConnectionHashKey;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramBendPointLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramConnectionLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramNodeLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public abstract class StandardDiagramLayoutPersistenceService
extends DiagramLayoutPersistenceService {
    protected StandardDiagramLayout layoutModel;
    protected IEditorInput editorInput;
    private Listener diagramEditorPagePartListener;
    private Listener connectionPartListener;
    private Map<String, DiagramNodeBounds> nodeBounds;
    private Map<ConnectionHashKey, List<Point>> connectionBendPoints;
    private Map<ConnectionHashKey, Point> connectionLabelPositions;
    private boolean dirty;
    private Map<ConnectionHashKey, DiagramConnectionPart> connectionIdMap;
    private Map<String, DiagramNodePart> nodeIdMap;
    private boolean autoLayout = false;

    protected void init() {
        super.init();
        this.editorInput = (IEditorInput)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getLocalModelElement().adapt(IEditorInput.class);
        this.nodeBounds = new HashMap<String, DiagramNodeBounds>();
        this.connectionBendPoints = new HashMap<ConnectionHashKey, List<Point>>();
        this.connectionLabelPositions = new HashMap<ConnectionHashKey, Point>();
        this.dirty = false;
        this.connectionPartListener = new FilteredListener<ConnectionEvent>(){

            protected void handleTypedEvent(ConnectionEvent event) {
                DiagramConnectionPart connPart = event.part();
                if (event instanceof ConnectionLabelEvent) {
                    if (((ConnectionLabelEvent)event).moveLabel()) {
                        StandardDiagramLayoutPersistenceService.this.write(connPart);
                    }
                } else if (event instanceof ConnectionBendpointsEvent) {
                    ConnectionBendpointsEvent bpEvent = (ConnectionBendpointsEvent)event;
                    if (bpEvent.reset()) {
                        if (StandardDiagramLayoutPersistenceService.this.autoLayout) {
                            StandardDiagramLayoutPersistenceService.this.addConnectionToPersistenceCache(event.part());
                            StandardDiagramLayoutPersistenceService.this.refreshDirtyState();
                        } else {
                            StandardDiagramLayoutPersistenceService.this.write(event.part());
                        }
                    } else {
                        StandardDiagramLayoutPersistenceService.this.write(event.part());
                    }
                }
            }
        };
        try {
            this.load();
            this.refreshPersistedPartsCache();
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        this.addDiagramPartListener();
    }

    public void dispose() {
        if (this.diagramEditorPagePartListener != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).detach(this.diagramEditorPagePartListener);
        }
    }

    protected abstract StandardDiagramLayout initLayoutModel();

    public void load() throws ResourceStoreException, CoreException, IOException {
        this.layoutModel = this.initLayoutModel();
        if (this.layoutModel == null) {
            return;
        }
        Boolean gridVisible = (Boolean)this.layoutModel.getGridLayout().isVisible().content();
        Boolean showGuides = (Boolean)this.layoutModel.getGuidesLayout().isVisible().content();
        if (gridVisible != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setGridVisible(gridVisible);
        }
        if (showGuides != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setShowGuides(showGuides);
        }
        ElementList<DiagramNodeLayout> nodes = this.layoutModel.getDiagramNodesLayout();
        ConnectionService connService = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramNodeLayout node : nodes) {
            String nodeId = (String)node.getNodeId().content();
            DiagramNodePart nodePart = this.getNodePart(nodeId);
            int x = (Integer)node.getX().content();
            int y = (Integer)node.getY().content();
            int width = (Integer)node.getWidth().content();
            int height = (Integer)node.getHeight().content();
            if (nodePart != null) {
                nodePart.setNodeBounds(new DiagramNodeBounds(x, y, width, height, false, false));
            }
            ElementList<DiagramConnectionLayout> connList = node.getEmbeddedConnectionsLayout();
            for (DiagramConnectionLayout connLayout : connList) {
                String connId = (String)connLayout.getConnectionId().content();
                ElementList<DiagramBendPointLayout> bps = connLayout.getConnectionBendpoints();
                DiagramConnectionPart connPart = this.getConnectionPart(connService, ConnectionHashKey.createKey(nodeId, connId));
                if (connPart == null) continue;
                int index = 0;
                for (DiagramBendPointLayout pt : bps) {
                    connPart.addBendpoint(index++, (Integer)pt.getX().content(), (Integer)pt.getY().content());
                }
                if (connLayout.getLabelX().content(false) == null || connLayout.getLabelY().content(false) == null) continue;
                Point labelPos = new Point((Integer)connLayout.getLabelX().content(), (Integer)connLayout.getLabelY().content());
                connPart.setLabelPosition(labelPos);
            }
        }
        ElementList<DiagramConnectionLayout> connList = this.layoutModel.getDiagramConnectionsLayout();
        for (DiagramConnectionLayout connLayout : connList) {
            String connId = (String)connLayout.getConnectionId().content();
            DiagramConnectionPart connPart = this.getConnectionPart(connService, ConnectionHashKey.createKey(null, connId));
            ElementList<DiagramBendPointLayout> bps = connLayout.getConnectionBendpoints();
            if (connPart == null) continue;
            int index = 0;
            for (DiagramBendPointLayout pt : bps) {
                connPart.addBendpoint(index++, (Integer)pt.getX().content(), (Integer)pt.getY().content());
            }
            ArrayList<Point> bendPoints = new ArrayList<Point>();
            bendPoints.addAll(connPart.getBendpoints());
            if (connLayout.getLabelX().content(false) == null || connLayout.getLabelY().content(false) == null) continue;
            Point labelPos = new Point((Integer)connLayout.getLabelX().content(), (Integer)connLayout.getLabelY().content());
            connPart.setLabelPosition(labelPos);
        }
        for (DiagramConnectionPart connPart : connService.list()) {
            connPart.attach(this.connectionPartListener);
        }
    }

    protected String computeLayoutFileName(IEditorInput editorInput) throws CoreException, IOException {
        IStorageEditorInput storageEditorInput;
        IPath storagePath;
        String uniquePath = null;
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            IFile ifile = fileEditorInput.getFile();
            uniquePath = ifile.getLocation().toPortableString();
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreInput = (FileStoreEditorInput)editorInput;
            IFileStore store = EFS.getStore((URI)fileStoreInput.getURI());
            File localFile = store.toLocalFile(0, null);
            if (localFile == null) {
                localFile = store.toLocalFile(4096, null);
            }
            if (localFile == null) {
                throw new IllegalArgumentException();
            }
            uniquePath = localFile.getCanonicalPath();
        } else if (editorInput instanceof IStorageEditorInput && (storagePath = (storageEditorInput = (IStorageEditorInput)editorInput).getStorage().getFullPath()) != null) {
            uniquePath = storagePath.toPortableString();
        }
        return uniquePath != null ? MiscUtil.createStringDigest((String)uniquePath) : null;
    }

    public void save() {
        if (this.layoutModel == null) {
            return;
        }
        this.addNodeBoundsToModel();
        this.addConnectionsToModel();
        this.refreshPersistedPartsCache();
        try {
            this.layoutModel.resource().save();
        }
        catch (ResourceStoreException rse) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)rse);
        }
        this.dirty = false;
    }

    private void read(DiagramNodePart nodePart) {
        String id = nodePart.getId();
        if (this.nodeBounds.containsKey(id) && this.nodeBounds.get(id) != null) {
            nodePart.setNodeBounds(this.nodeBounds.get(id));
        }
    }

    private void write(DiagramNodePart nodePart) {
        this.refreshDirtyState();
    }

    @Override
    public DiagramLayoutPersistenceService.DiagramConnectionInfo read(DiagramConnectionPart connPart) {
        ConnectionHashKey key = ConnectionHashKey.createKey(connPart);
        if (this.connectionBendPoints.containsKey(key)) {
            DiagramLayoutPersistenceService.DiagramConnectionInfo connectionInfo = new DiagramLayoutPersistenceService.DiagramConnectionInfo(this.connectionBendPoints.get(key), this.connectionLabelPositions.get(key));
            return connectionInfo;
        }
        return null;
    }

    private void write(DiagramConnectionPart connPart) {
        this.refreshDirtyState();
    }

    private void setGridVisible(boolean visible) {
        if (this.layoutModel != null) {
            this.layoutModel.getGridLayout().setVisible(visible);
        }
    }

    private void setGuidesVisible(boolean visible) {
        if (this.layoutModel != null) {
            this.layoutModel.getGuidesLayout().setVisible(visible);
        }
    }

    private void addNodeBoundsToModel() {
        this.layoutModel.getDiagramNodesLayout().clear();
        for (DiagramNodeTemplate nodeTemplate : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodeTemplates()) {
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                String nodeId = nodePart.getId();
                DiagramNodeLayout diagramNode = (DiagramNodeLayout)this.layoutModel.getDiagramNodesLayout().insert();
                diagramNode.setNodeId(nodeId);
                DiagramNodeBounds bounds = nodePart.getNodeBounds();
                diagramNode.setX(bounds.getX());
                diagramNode.setY(bounds.getY());
                if (nodePart.canResizeShape()) {
                    IDiagramNodeDef nodeDef = (IDiagramNodeDef)nodePart.definition();
                    if (bounds.getHeight() != -1 && (nodeDef.getHeight().content() != null && ((Integer)nodeDef.getHeight().content()).intValue() != bounds.getHeight() || nodeDef.getHeight().content() == null)) {
                        diagramNode.setHeight(bounds.getHeight());
                    }
                    if (bounds.getWidth() != -1 && (nodeDef.getWidth().content() != null && ((Integer)nodeDef.getWidth().content()).intValue() != bounds.getWidth() || nodeDef.getWidth().content() == null)) {
                        diagramNode.setWidth(bounds.getWidth());
                    }
                }
                diagramNode.getEmbeddedConnectionsLayout().clear();
                if (nodePart.getDiagramNodeTemplate().getEmbeddedConnectionTemplate() == null) continue;
                Element nodeElement = nodePart.getLocalModelElement();
                List<StandardDiagramConnectionPart> connParts = nodePart.getDiagramNodeTemplate().getEmbeddedConnectionTemplate().getDiagramConnections(nodeElement);
                for (StandardDiagramConnectionPart connPart : connParts) {
                    String connId = connPart.getId();
                    DiagramConnectionLayout conn = null;
                    List<Point> connBendPoints = connPart.getBendpoints();
                    if (connBendPoints.size() > 0) {
                        conn = (DiagramConnectionLayout)diagramNode.getEmbeddedConnectionsLayout().insert();
                        conn.setConnectionId(connId);
                        for (Point pt : connBendPoints) {
                            DiagramBendPointLayout pt2 = (DiagramBendPointLayout)conn.getConnectionBendpoints().insert();
                            pt2.setX(pt.getX());
                            pt2.setY(pt.getY());
                        }
                    }
                    if (connPart.getLabel() == null || connPart.getLabelPosition() == null) continue;
                    if (conn == null) {
                        conn = (DiagramConnectionLayout)diagramNode.getEmbeddedConnectionsLayout().insert();
                        conn.setConnectionId(connId);
                    }
                    conn.setLabelX(connPart.getLabelPosition().getX());
                    conn.setLabelY(connPart.getLabelPosition().getY());
                }
            }
        }
    }

    private void addConnectionsToModel() {
        this.layoutModel.getDiagramConnectionsLayout().clear();
        ConnectionService connService = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            if (!connPart.removable() || connPart instanceof StandardEmbeddedConnectionPart) continue;
            String id = connPart.getId();
            DiagramConnectionLayout conn = null;
            List<Point> connBendPoints = connPart.getBendpoints();
            if (connBendPoints.size() > 0) {
                conn = (DiagramConnectionLayout)this.layoutModel.getDiagramConnectionsLayout().insert();
                conn.setConnectionId(id);
                for (Point pt : connBendPoints) {
                    DiagramBendPointLayout pt2 = (DiagramBendPointLayout)conn.getConnectionBendpoints().insert();
                    pt2.setX(pt.getX());
                    pt2.setY(pt.getY());
                }
            }
            if (connPart.getLabel() == null || connPart.getLabelPosition() == null) continue;
            if (conn == null) {
                conn = (DiagramConnectionLayout)this.layoutModel.getDiagramConnectionsLayout().insert();
                conn.setConnectionId(id);
            }
            conn.setLabelX(connPart.getLabelPosition().getX());
            conn.setLabelY(connPart.getLabelPosition().getY());
        }
    }

    private void addNodeToPersistenceCache(DiagramNodePart nodePart) {
        String nodeId = nodePart.getId();
        this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
    }

    private void addConnectionToPersistenceCache(DiagramConnectionPart connPart) {
        ConnectionHashKey connKey = ConnectionHashKey.createKey(connPart);
        this.connectionBendPoints.put(connKey, connPart.getBendpoints());
        if (connPart.getLabel() != null && connPart.getLabelPosition() != null) {
            this.connectionLabelPositions.put(connKey, new Point(connPart.getLabelPosition()));
        }
    }

    private void refreshPersistedPartsCache() {
        this.nodeBounds.clear();
        this.connectionBendPoints.clear();
        ConnectionService connService = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            if (!connPart.removable()) continue;
            this.addConnectionToPersistenceCache(connPart);
        }
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            this.addNodeToPersistenceCache(nodePart);
        }
    }

    private void addDiagramPartListener() {
        this.diagramEditorPagePartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof DiagramNodeEvent) {
                    StandardDiagramLayoutPersistenceService.this.handleDiagramNodeEvent((DiagramNodeEvent)event);
                } else if (event instanceof DiagramPageEvent) {
                    StandardDiagramLayoutPersistenceService.this.handleDiagramPageEvent((DiagramPageEvent)event);
                } else if (event instanceof SapphireDiagramEditorPagePart.PreAutoLayoutEvent) {
                    StandardDiagramLayoutPersistenceService.this.autoLayout = true;
                } else if (event instanceof SapphireDiagramEditorPagePart.PostAutoLayoutEvent) {
                    StandardDiagramLayoutPersistenceService.this.autoLayout = false;
                } else if (event instanceof ConnectionAddEvent) {
                    StandardDiagramLayoutPersistenceService.this.handleConnectionAddEvent((ConnectionAddEvent)event);
                } else if (event instanceof ConnectionDeleteEvent) {
                    StandardDiagramLayoutPersistenceService.this.handleConnectionDeleteEvent((ConnectionDeleteEvent)event);
                }
            }
        };
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).attach(this.diagramEditorPagePartListener);
    }

    private void handleDiagramNodeEvent(DiagramNodeEvent event) {
        DiagramNodePart nodePart = event.part();
        if (event instanceof DiagramNodeAddEvent) {
            this.read(nodePart);
        } else if (event instanceof DiagramNodeDeleteEvent) {
            this.refreshDirtyState();
        } else if (event instanceof DiagramNodeMoveEvent) {
            DiagramNodeBounds nodeBounds = nodePart.getNodeBounds();
            if (nodeBounds.isAutoLayout()) {
                this.addNodeToPersistenceCache(nodePart);
                this.refreshDirtyState();
            } else if (!nodeBounds.isDefaultPosition()) {
                this.write(event.part());
            }
        }
    }

    protected void handleConnectionAddEvent(ConnectionAddEvent event) {
        DiagramConnectionPart connPart = event.part();
        connPart.attach(this.connectionPartListener);
        DiagramLayoutPersistenceService.DiagramConnectionInfo connInfo = this.read(connPart);
        if (connInfo != null) {
            connPart.resetBendpoints(connInfo.getBendPoints());
            if (connInfo.getLabelPosition() != null) {
                connPart.setLabelPosition(connInfo.getLabelPosition());
            }
        }
    }

    protected void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
        this.refreshDirtyState();
    }

    private void handleDiagramPageEvent(DiagramPageEvent event) {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.part();
        switch (event.getDiagramPageEventType()) {
            case GridStateChange: {
                this.setGridVisible(diagramPart.isGridVisible());
                break;
            }
            case GuideStateChange: {
                this.setGuidesVisible(diagramPart.isShowGuides());
                break;
            }
            case DiagramSave: {
                this.save();
                break;
            }
        }
    }

    private boolean isNodeLayoutChanged(DiagramNodePart nodePart) {
        DiagramNodeBounds newBounds = nodePart.getNodeBounds();
        boolean changed = false;
        String nodeId = nodePart.getId();
        if (this.nodeBounds.containsKey(nodeId)) {
            DiagramNodeBounds oldBounds = this.nodeBounds.get(nodeId);
            if (!newBounds.equals(oldBounds)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isConnectionLayoutChanged(DiagramConnectionPart connPart) {
        List<Point> bendpoints = connPart.getBendpoints();
        ConnectionHashKey key = ConnectionHashKey.createKey(connPart);
        boolean changed = false;
        if (this.connectionBendPoints.containsKey(key)) {
            List<Point> oldBendpoints = this.connectionBendPoints.get(key);
            if (bendpoints.size() != oldBendpoints.size()) {
                changed = true;
            } else {
                int i = 0;
                while (i < bendpoints.size()) {
                    Point newPt = bendpoints.get(i);
                    Point oldPt = oldBendpoints.get(i);
                    if (newPt.getX() != oldPt.getX() || newPt.getY() != oldPt.getY()) {
                        changed = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!changed && connPart.getLabel() != null) {
                Point newPos = connPart.getLabelPosition();
                Point oldPos = this.connectionLabelPositions.get(key);
                if (newPos == null && oldPos != null || newPos != null && oldPos == null || newPos != null && oldPos != null && !newPos.equals(oldPos)) {
                    changed = true;
                }
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isDiagramLayoutChanged() {
        boolean changed = false;
        if (!((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).disposed()) {
            for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
                if (nodePart.getLocalModelElement().disposed() || !this.isNodeLayoutChanged(nodePart)) continue;
                changed = true;
                break;
            }
            ConnectionService connService = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
            for (DiagramConnectionPart connPart : connService.list()) {
                if (connPart.getLocalModelElement().disposed() || !connPart.removable() || !this.isConnectionLayoutChanged(connPart)) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    @Override
    public boolean dirty() {
        return this.dirty;
    }

    private void refreshDirtyState() {
        boolean after = this.isDiagramLayoutChanged();
        if (this.dirty != after) {
            boolean before = this.dirty;
            this.dirty = after;
            this.broadcast((Event)new DiagramLayoutPersistenceService.DirtyStateEvent(this, before, after));
        }
    }

    private DiagramConnectionPart getConnectionPart(ConnectionService connService, ConnectionHashKey connId) {
        if (this.connectionIdMap == null) {
            this.connectionIdMap = new HashMap<ConnectionHashKey, DiagramConnectionPart>();
            for (DiagramConnectionPart connPart : connService.list()) {
                this.connectionIdMap.put(ConnectionHashKey.createKey(connPart), connPart);
            }
        }
        return this.connectionIdMap.get(connId);
    }

    private DiagramNodePart getNodePart(String nodeId) {
        if (this.nodeIdMap == null) {
            this.nodeIdMap = new HashMap<String, DiagramNodePart>();
            for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
                this.nodeIdMap.put(nodePart.getId(), nodePart);
            }
        }
        return this.nodeIdMap.get(nodeId);
    }
}

