/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import org.eclipse.sapphire.modeling.el.ConcatFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.HtmlContentSourceType;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.HtmlPanelDef;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.HtmlPanelPresentation;
import org.eclipse.swt.widgets.Composite;

public final class HtmlPanelPart
extends FormComponentPart {
    private static final String FRAGMENT_STYLE = MiscUtil.readTextResource(HtmlPanelPart.class, (String)"FragmentStyle.css");
    private static final String FRAGMENT_HEADER = "<html><head><style>" + FRAGMENT_STYLE + "</style></head><body>";
    private static final String FRAGMENT_FOOTER = "</body></html>";
    private HtmlPanelDef def;
    private FunctionResult contentFunctionResult;
    private FunctionResult urlFunctionResult;

    @Override
    protected void init() {
        super.init();
        this.def = (HtmlPanelDef)this.definition;
        if (this.def.getContentSourceType().content() == HtmlContentSourceType.EMBEDDED) {
            Function contentFunction = (Function)this.def.getContent().content();
            if (((Boolean)this.def.getFragment().content()).booleanValue()) {
                contentFunction = ConcatFunction.create((String)FRAGMENT_HEADER, (Function)contentFunction);
                contentFunction = ConcatFunction.create((Function)contentFunction, (String)FRAGMENT_FOOTER);
            }
            this.contentFunctionResult = this.initExpression(contentFunction, String.class, null, new Runnable(){

                @Override
                public void run() {
                    HtmlPanelPart.this.broadcast(new ContentEvent(HtmlPanelPart.this));
                }
            });
        } else {
            this.urlFunctionResult = this.initExpression((Function)this.def.getContentUrl().content(), String.class, null, new Runnable(){

                @Override
                public void run() {
                    HtmlPanelPart.this.broadcast(new ContentEvent(HtmlPanelPart.this));
                }
            });
        }
    }

    @Override
    public HtmlPanelDef definition() {
        return (HtmlPanelDef)super.definition();
    }

    public String content() {
        if (this.contentFunctionResult == null) {
            return null;
        }
        return (String)this.contentFunctionResult.value();
    }

    public String url() {
        if (this.urlFunctionResult == null) {
            return null;
        }
        return (String)this.urlFunctionResult.value();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.contentFunctionResult != null) {
            this.contentFunctionResult.dispose();
        }
        if (this.urlFunctionResult != null) {
            this.urlFunctionResult.dispose();
        }
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new HtmlPanelPresentation(this, parent, composite);
    }

    public static final class ContentEvent
    extends SapphirePart.PartEvent {
        public ContentEvent(SapphirePart part) {
            super(part);
        }
    }
}

