/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.FormEditorPageDef;
import org.eclipse.sapphire.ui.forms.FormEditorPagePart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class FormEditorPage
extends SapphireEditorFormPage {
    public FormEditorPage(SapphireEditor editor, Element element, DefinitionLoader.Reference<EditorPageDef> definition) {
        this(editor, element, definition, null);
    }

    public FormEditorPage(SapphireEditor editor, Element element, DefinitionLoader.Reference<EditorPageDef> definition, String pageName) {
        super(editor, element, definition);
        String partName = pageName;
        if (partName == null) {
            partName = this.getDefinition().getPageName().localized(CapitalizationType.TITLE_STYLE, false);
        }
        this.setPartName(partName);
    }

    @Override
    public FormEditorPagePart getPart() {
        return (FormEditorPagePart)super.getPart();
    }

    public FormEditorPageDef getDefinition() {
        return this.getPart().definition();
    }

    @Override
    public String getId() {
        return this.getPartName();
    }

    protected void createFormContent(final IManagedForm managedForm) {
        final FormEditorPagePart part = this.getPart();
        final ScrolledForm form = managedForm.getForm();
        final Composite body = form.getForm().getBody();
        SwtPresentation presentation = new SwtPresentation(part, null, body.getShell()){

            @Override
            public void render() {
                body.setData("Sapphire.LayoutRoot", (Object)Boolean.TRUE);
                body.setBackground(FormEditorPage.this.getPart().getSwtResourceCache().color(Color.WHITE));
                body.setBackgroundMode(1);
                managedForm.getToolkit().decorateFormHeading(managedForm.getForm().getForm());
                body.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
                for (FormComponentPart child : part.getChildParts()) {
                    FormComponentPresentation childPresentation = child.createPresentation(null, body);
                    childPresentation.render();
                }
                ISapphireDocumentation doc = (ISapphireDocumentation)part.definition().getDocumentation().content();
                if (doc != null) {
                    ISapphireDocumentationDef docdef = null;
                    docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
                    if (docdef != null) {
                        HelpSystem.setHelp((Control)body, docdef);
                    }
                }
                SapphireActionGroup actions = part.getActions("Sapphire.EditorPage");
                SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(this, actions);
                SapphireToolBarManagerActionPresentation actionPresentation = new SapphireToolBarManagerActionPresentation(actionPresentationManager);
                actionPresentation.setToolBarManager(form.getToolBarManager());
                actionPresentation.render();
            }
        };
        presentation.render();
    }
}

