/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorCondition;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.Popup;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation2;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public final class CalendarBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Calendar";

    public CalendarBrowseActionHandler() {
        this.setId(ID);
    }

    @Override
    protected String browse(final Presentation context) {
        final MutableReference result = new MutableReference();
        Popup dialog = new Popup(((FormComponentPresentation)context).shell(), null){
            private DateTime calendar;

            @Override
            protected Point getInitialLocation(Point size) {
                return ((PropertyEditorPresentation2)context).getActionPopupPosition(size.x, size.y);
            }

            @Override
            protected Control createContentArea(Composite parent) {
                this.calendar = new DateTime(parent, 1024);
                Date existing = (Date)CalendarBrowseActionHandler.this.property().content();
                if (existing != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(existing);
                    this.calendar.setYear(cal.get(1));
                    this.calendar.setMonth(cal.get(2));
                    this.calendar.setDay(cal.get(5));
                }
                this.calendar.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent event) {
                        this.registerSelectionAndClose();
                    }
                });
                this.calendar.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent event) {
                        if (event.character == '\r') {
                            this.registerSelectionAndClose();
                        }
                    }
                });
                return this.calendar;
            }

            private void registerSelectionAndClose() {
                Calendar cal = Calendar.getInstance();
                cal.set(this.calendar.getYear(), this.calendar.getMonth(), this.calendar.getDay());
                Date date = cal.getTime();
                result.set((Object)((String)((MasterConversionService)CalendarBrowseActionHandler.this.property().service(MasterConversionService.class)).convert((Object)date, String.class)));
                this.close();
            }
        };
        dialog.setBlockOnOpen(true);
        dialog.open();
        return (String)result.get();
    }

    public static final class Condition
    extends PropertyEditorCondition {
        @Override
        protected boolean evaluate(PropertyEditorPart part) {
            return part.property().definition().getTypeClass() == Date.class;
        }
    }
}

