/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.collation;

import java.util.Comparator;
import org.eclipse.sapphire.CollationService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.collation.TestElement;
import org.junit.Test;

public final class CollationTests
extends SapphireTestCase {
    @Test
    public void NoCollationSpecified() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            CollationService serviceFromInstanceContext = (CollationService)element.getNoCollationSpecified().service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromInstanceContext);
            CollationService serviceFromGlobalContext = (CollationService)TestElement.PROP_NO_COLLATION_SPECIFIED.service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromGlobalContext);
            CollationTests.assertSame((Object)serviceFromGlobalContext, (Object)serviceFromInstanceContext);
            Comparator comparator = serviceFromInstanceContext.comparator();
            CollationTests.assertTrue((comparator.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator.compare("A", "a") != 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void IgnoreCaseLiteralFalse() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            CollationService serviceFromInstanceContext = (CollationService)element.getIgnoreCaseLiteralFalse().service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromInstanceContext);
            CollationService serviceFromGlobalContext = (CollationService)TestElement.PROP_IGNORE_CASE_LITERAL_FALSE.service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromGlobalContext);
            CollationTests.assertSame((Object)serviceFromGlobalContext, (Object)serviceFromInstanceContext);
            Comparator comparator = serviceFromInstanceContext.comparator();
            CollationTests.assertTrue((comparator.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator.compare("A", "a") != 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void IgnoreCaseLiteralTrue() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            CollationService serviceFromInstanceContext = (CollationService)element.getIgnoreCaseLiteralTrue().service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromInstanceContext);
            CollationService serviceFromGlobalContext = (CollationService)TestElement.PROP_IGNORE_CASE_LITERAL_TRUE.service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromGlobalContext);
            CollationTests.assertSame((Object)serviceFromGlobalContext, (Object)serviceFromInstanceContext);
            Comparator comparator = serviceFromInstanceContext.comparator();
            CollationTests.assertTrue((comparator.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator.compare("A", "a") == 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void IgnoreCaseDynamic() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            CollationService serviceFromInstanceContext = (CollationService)element.getIgnoreCaseDynamic().service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromInstanceContext);
            CollationService serviceFromGlobalContext = (CollationService)TestElement.PROP_IGNORE_CASE_DYNAMIC.service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromGlobalContext);
            CollationTests.assertNotSame((Object)serviceFromGlobalContext, (Object)serviceFromInstanceContext);
            Comparator comparator1 = serviceFromInstanceContext.comparator();
            CollationTests.assertTrue((comparator1.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator1.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator1.compare("A", "a") != 0 ? 1 : 0) != 0);
            element.setIgnoreCase(true);
            Comparator comparator2 = serviceFromInstanceContext.comparator();
            CollationTests.assertNotSame((Object)comparator2, (Object)comparator1);
            CollationTests.assertTrue((comparator2.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator2.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator2.compare("A", "a") == 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void IgnoreCaseDynamicGlobal() {
        Sapphire.global().put((Object)"TestIgnoreCase", (Object)false);
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            CollationService serviceFromInstanceContext = (CollationService)element.getIgnoreCaseDynamicGlobal().service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromInstanceContext);
            CollationService serviceFromGlobalContext = (CollationService)TestElement.PROP_IGNORE_CASE_DYNAMIC_GLOBAL.service(CollationService.class);
            CollationTests.assertNotNull((Object)serviceFromGlobalContext);
            CollationTests.assertSame((Object)serviceFromGlobalContext, (Object)serviceFromInstanceContext);
            Comparator comparator1 = serviceFromInstanceContext.comparator();
            CollationTests.assertTrue((comparator1.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator1.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator1.compare("A", "a") != 0 ? 1 : 0) != 0);
            Sapphire.global().put((Object)"TestIgnoreCase", (Object)true);
            Comparator comparator2 = serviceFromInstanceContext.comparator();
            CollationTests.assertNotSame((Object)comparator2, (Object)comparator1);
            CollationTests.assertTrue((comparator2.compare("a", "b") < 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator2.compare("b", "a") > 0 ? 1 : 0) != 0);
            CollationTests.assertTrue((comparator2.compare("A", "a") == 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

