/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.path.relative;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.path.relative.TestElement;
import org.junit.Test;

public final class RelativePathTests
extends SapphireTestCase {
    @Test
    public void MustExistValidation_WhenRootChanges() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            IProject project = this.project();
            IFolder aFolder = project.getFolder("a");
            String aFolderPath = aFolder.getLocation().toString();
            aFolder.create(true, true, null);
            IFolder bFolder = project.getFolder("b");
            String bFolderPath = bFolder.getLocation().toString();
            IFile bFile = bFolder.getFile("abc.bin");
            bFolder.create(true, true, null);
            byte[] byArray = new byte[2];
            byArray[1] = 1;
            bFile.create((InputStream)new ByteArrayInputStream(byArray), true, null);
            element.setRootPath(aFolderPath);
            element.setRelativePath("abc.bin");
            RelativePathTests.assertValidationError(element.getRelativePath(), "File or folder \"abc.bin\" does not exist");
            element.setRootPath(bFolderPath);
            RelativePathTests.assertValidationOk(element.getRelativePath());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

