/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.property;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.junit.Test;

public final class ElementPropertyTests
extends SapphireTestCase {
    @Test
    public void OrderedPossibleTypes() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (OrderedPossibleTypesTestElement a = (OrderedPossibleTypesTestElement)OrderedPossibleTypesTestElement.TYPE.instantiate();){
            PossibleTypesService unorderedPossibleTypesService = (PossibleTypesService)a.getElementWithUnorderedPossibleTypes().service(PossibleTypesService.class);
            ElementPropertyTests.assertEquals((Object)false, (Object)unorderedPossibleTypesService.ordered());
            ElementPropertyTests.assertSetOrder(unorderedPossibleTypesService.types(), OrderedPossibleTypesTestElement.Child1.TYPE, OrderedPossibleTypesTestElement.Child2.TYPE, OrderedPossibleTypesTestElement.Child3.TYPE);
            PossibleTypesService orderedPossibleTypesService = (PossibleTypesService)a.getElementWithOrderedPossibleTypes().service(PossibleTypesService.class);
            ElementPropertyTests.assertEquals((Object)true, (Object)orderedPossibleTypesService.ordered());
            ElementPropertyTests.assertSetOrder(orderedPossibleTypesService.types(), OrderedPossibleTypesTestElement.Child2.TYPE, OrderedPossibleTypesTestElement.Child1.TYPE, OrderedPossibleTypesTestElement.Child3.TYPE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static interface OrderedPossibleTypesTestElement
    extends Element {
        public static final ElementType TYPE = new ElementType(OrderedPossibleTypesTestElement.class);
        @Type(base=Child.class, possible={Child2.class, Child1.class, Child3.class})
        public static final ElementProperty PROP_ELEMENT_WITH_UNORDERED_POSSIBLE_TYPES = new ElementProperty(TYPE, "ElementWithUnorderedPossibleTypes");
        @Type(base=Child.class, possible={Child2.class, Child1.class, Child3.class}, ordered=true)
        public static final ElementProperty PROP_ELEMENT_WITH_ORDERED_POSSIBLE_TYPES = new ElementProperty(TYPE, "ElementWithOrderedPossibleTypes");

        public ElementHandle<Child> getElementWithUnorderedPossibleTypes();

        public ElementHandle<Child> getElementWithOrderedPossibleTypes();

        public static interface Child
        extends Element {
            public static final ElementType TYPE = new ElementType(Child.class);
            public static final ValueProperty PROP_VALUE = new ValueProperty(TYPE, "Value");

            public Value<String> getValue();

            public void setValue(String var1);
        }

        public static interface Child1
        extends Child {
            public static final ElementType TYPE = new ElementType(Child1.class);
        }

        public static interface Child2
        extends Child {
            public static final ElementType TYPE = new ElementType(Child2.class);
        }

        public static interface Child3
        extends Child {
            public static final ElementType TYPE = new ElementType(Child3.class);
        }
    }
}

