/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.property;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Suspension;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.element.TestElement;
import org.junit.Test;

public final class PropertyTests
extends SapphireTestCase {
    @Test
    public void HoldsElement() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement a = (TestElement)TestElement.TYPE.instantiate();){
            TestElement aa = (TestElement)a.getElement().content(true);
            PropertyTests.assertTrue((boolean)a.getElement().holds((Element)aa));
            PropertyTests.assertFalse((boolean)a.getValue().holds((Element)aa));
            PropertyTests.assertFalse((boolean)a.getTransient().holds((Element)aa));
            PropertyTests.assertFalse((boolean)a.getList().holds((Element)aa));
            TestElement aaa = (TestElement)aa.getList().insert();
            PropertyTests.assertTrue((boolean)a.getElement().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)a.getValue().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)a.getTransient().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)a.getList().holds((Element)aaa));
            PropertyTests.assertTrue((boolean)aa.getList().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)aa.getValue().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)aa.getTransient().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)aa.getElement().holds((Element)aaa));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void HoldsProperty() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement a = (TestElement)TestElement.TYPE.instantiate();){
            TestElement aa = (TestElement)a.getElement().content(true);
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getValue()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getTransient()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getElement()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getList()));
            PropertyTests.assertFalse((boolean)a.getValue().holds(aa.getValue()));
            PropertyTests.assertFalse((boolean)a.getTransient().holds(aa.getValue()));
            PropertyTests.assertFalse((boolean)a.getList().holds(aa.getValue()));
            TestElement aaa = (TestElement)aa.getList().insert();
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getValue()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getTransient()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getElement()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getList()));
            PropertyTests.assertFalse((boolean)a.getValue().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)a.getTransient().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)a.getList().holds(aaa.getValue()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getValue()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getTransient()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getElement()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getList()));
            PropertyTests.assertFalse((boolean)aa.getValue().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)aa.getTransient().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)aa.getElement().holds(aaa.getValue()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void Suspend() {
        EventLog log = new EventLog();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TestElement a = (TestElement)TestElement.TYPE.instantiate();){
            a.attach(log, "*");
            TestElement aa = (TestElement)a.getElement().content(true);
            aa.setValue("abc");
            aa.getList().insert();
            PropertyTests.assertEquals((long)3L, (long)log.size());
            PropertyTests.assertPropertyContentEvent(log.event(0), a.getElement());
            PropertyTests.assertPropertyContentEvent(log.event(1), aa.getValue());
            PropertyTests.assertPropertyContentEvent(log.event(2), aa.getList());
            log.clear();
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (Suspension suspension = a.getElement().suspend();){
                aa.setValue("def");
                ((TestElement)aa.getList().insert()).setValue("ghi");
                ((TestElement)aa.getElement().content(true)).setValue("klm");
                PropertyTests.assertEquals((long)0L, (long)log.size());
                a.setValue("nop");
                PropertyTests.assertEquals((long)1L, (long)log.size());
                PropertyTests.assertPropertyContentEvent(log.event(0), a.getValue());
                log.clear();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            PropertyTests.assertEquals((long)5L, (long)log.size());
            PropertyTests.assertPropertyContentEvent(log.event(0), aa.getValue());
            PropertyTests.assertPropertyContentEvent(log.event(1), aa.getList());
            PropertyTests.assertPropertyContentEvent(log.event(2), ((TestElement)aa.getList().get(1)).getValue());
            PropertyTests.assertPropertyContentEvent(log.event(3), aa.getElement());
            PropertyTests.assertPropertyContentEvent(log.event(4), ((TestElement)aa.getElement().content()).getValue());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

