/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.reference.element;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.reference.element.ExternalElementReferenceService;
import org.eclipse.sapphire.tests.reference.element.TestElement;
import org.junit.Test;

public final class ElementReferenceTests
extends SapphireTestCase {
    @Test
    public void DeclarativeElementReference() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            TestElement.Item b = (TestElement.Item)element.getItemList1().insert();
            b.setName("b");
            TestElement.Item c = (TestElement.Item)element.getItemList1().insert();
            c.setName("c");
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
            element.setDeclarativeReference("a");
            ElementReferenceTests.assertSame((Object)a, (Object)element.getDeclarativeReference().target());
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
            element.setDeclarativeReference("c");
            ElementReferenceTests.assertSame((Object)c, (Object)element.getDeclarativeReference().target());
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
            element.setDeclarativeReference("d");
            ElementReferenceTests.assertNull((Object)element.getDeclarativeReference().target());
            ElementReferenceTests.assertValidationError(element.getDeclarativeReference(), "Could not resolve declarative reference \"d\"");
            PossibleValuesService possibleValuesService = (PossibleValuesService)element.getDeclarativeReference().service(PossibleValuesService.class);
            ElementReferenceTests.assertNotNull((Object)possibleValuesService);
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c"), (Object)possibleValuesService.values());
            TestElement.Item d = (TestElement.Item)element.getItemList1().insert();
            d.setName("d");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "d"), (Object)possibleValuesService.values());
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void DeclarativeElementReference_Refactoring() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            this.testRefactoring(element.getItemList1(), element.getDeclarativeReference());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void DeclarativeElementReference_Write() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            TestElement.Item b = (TestElement.Item)element.getItemList1().insert();
            b.setName("b");
            TestElement.Item c = (TestElement.Item)element.getItemList1().insert();
            c.setName("c");
            element.setDeclarativeReference(a);
            ElementReferenceTests.assertEquals((Object)"a", (Object)element.getDeclarativeReference().text());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void DeclarativeElementReference_Write_Foreign_1() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            element.setDeclarativeReference(a);
            ElementReferenceTests.assertEquals((Object)"a", (Object)element.getDeclarativeReference().text());
            TestElement.Item foreign = (TestElement.Item)element.getItemList2().insert();
            try {
                element.setDeclarativeReference(foreign);
                ElementReferenceTests.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ElementReferenceTests.assertEquals((Object)"a", (Object)element.getDeclarativeReference().text());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void DeclarativeElementReference_Write_Foreign_2() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            element.setDeclarativeReference(a);
            ElementReferenceTests.assertEquals((Object)"a", (Object)element.getDeclarativeReference().text());
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TestElement.Item foreign = (TestElement.Item)TestElement.Item.TYPE.instantiate();){
                try {
                    element.setDeclarativeReference(foreign);
                    ElementReferenceTests.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ElementReferenceTests.assertEquals((Object)"a", (Object)element.getDeclarativeReference().text());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void CustomElementReference() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            a.setValue("1");
            TestElement.Item b = (TestElement.Item)element.getItemList1().insert();
            b.setName("b");
            b.setValue("2");
            TestElement.Item c = (TestElement.Item)element.getItemList1().insert();
            c.setName("c");
            c.setValue("3");
            TestElement.Item x = (TestElement.Item)element.getItemList2().insert();
            x.setName("x");
            x.setValue("4");
            TestElement.Item y = (TestElement.Item)element.getItemList2().insert();
            y.setName("y");
            y.setValue("5");
            TestElement.Item z = (TestElement.Item)element.getItemList2().insert();
            z.setName("z");
            z.setValue("6");
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setCustomReference("a");
            ElementReferenceTests.assertSame((Object)a, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setCustomReference("c");
            ElementReferenceTests.assertSame((Object)c, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setCustomReference("d");
            ElementReferenceTests.assertNull((Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"d\"");
            PossibleValuesService possibleValuesService = (PossibleValuesService)element.getCustomReference().service(PossibleValuesService.class);
            ElementReferenceTests.assertNotNull((Object)possibleValuesService);
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c"), (Object)possibleValuesService.values());
            TestElement.Item d = (TestElement.Item)element.getItemList1().insert();
            d.setName("d");
            d.setValue("7");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "d"), (Object)possibleValuesService.values());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setUseItemList2(true);
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"d\"");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("x", "y", "z"), (Object)possibleValuesService.values());
            element.setCustomReference("y");
            ElementReferenceTests.assertSame((Object)y, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setUseValueAsKey(true);
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"y\"");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("4", "5", "6"), (Object)possibleValuesService.values());
            element.setCustomReference("6");
            ElementReferenceTests.assertSame((Object)z, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            z.setValue("67");
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"6\"");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("4", "5", "67"), (Object)possibleValuesService.values());
            element.setCustomReference("67");
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void CustomElementReference_Refactoring() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            this.testRefactoring(element.getItemList1(), element.getCustomReference());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void CustomElementReference_Write() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            a.setValue("1");
            TestElement.Item b = (TestElement.Item)element.getItemList1().insert();
            b.setName("b");
            b.setValue("2");
            TestElement.Item c = (TestElement.Item)element.getItemList1().insert();
            c.setName("c");
            c.setValue("3");
            TestElement.Item x = (TestElement.Item)element.getItemList2().insert();
            x.setName("x");
            x.setValue("4");
            TestElement.Item y = (TestElement.Item)element.getItemList2().insert();
            y.setName("y");
            y.setValue("5");
            TestElement.Item z = (TestElement.Item)element.getItemList2().insert();
            z.setName("z");
            z.setValue("6");
            element.setCustomReference(a);
            ElementReferenceTests.assertEquals((Object)"a", (Object)element.getCustomReference().text());
            element.setUseValueAsKey(true);
            element.setCustomReference(a);
            ElementReferenceTests.assertEquals((Object)"1", (Object)element.getCustomReference().text());
            element.setUseItemList2(true);
            element.setCustomReference(z);
            ElementReferenceTests.assertEquals((Object)"6", (Object)element.getCustomReference().text());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void ExternalElementReference() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            TestElement element = (TestElement)TestElement.TYPE.instantiate();
            try {
                try (TestElement external = (TestElement)TestElement.TYPE.instantiate();){
                    TestElement.Item a = (TestElement.Item)external.getItemList1().insert();
                    a.setName("a");
                    TestElement.Item b = (TestElement.Item)external.getItemList1().insert();
                    b.setName("b");
                    TestElement.Item c = (TestElement.Item)external.getItemList1().insert();
                    c.setName("c");
                    ((ExternalElementReferenceService)element.getExternalReference().service(ExternalElementReferenceService.class)).list(external.getItemList1());
                    ElementReferenceTests.assertValidationOk(element.getExternalReference());
                    element.setExternalReference("a");
                    ElementReferenceTests.assertSame((Object)a, (Object)element.getExternalReference().target());
                    ElementReferenceTests.assertValidationOk(element.getExternalReference());
                    element.setExternalReference("c");
                    ElementReferenceTests.assertSame((Object)c, (Object)element.getExternalReference().target());
                    ElementReferenceTests.assertValidationOk(element.getExternalReference());
                    element.setExternalReference("d");
                    ElementReferenceTests.assertNull((Object)element.getExternalReference().target());
                    ElementReferenceTests.assertValidationError(element.getExternalReference(), "Could not resolve external reference \"d\"");
                    PossibleValuesService possibleValuesService = (PossibleValuesService)element.getExternalReference().service(PossibleValuesService.class);
                    ElementReferenceTests.assertNotNull((Object)possibleValuesService);
                    ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c"), (Object)possibleValuesService.values());
                    TestElement.Item d = (TestElement.Item)external.getItemList1().insert();
                    d.setName("d");
                    ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "d"), (Object)possibleValuesService.values());
                    ElementReferenceTests.assertValidationOk(element.getExternalReference());
                    d.getName().write((Object)"dd", true);
                    ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "dd"), (Object)possibleValuesService.values());
                    ElementReferenceTests.assertEquals((Object)"dd", (Object)element.getExternalReference().content());
                    ElementReferenceTests.assertValidationOk(element.getExternalReference());
                }
                if (element == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (element == null) throw throwable;
                element.close();
                throw throwable;
            }
            element.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void ExternalElementReference_Refactoring() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            TestElement element = (TestElement)TestElement.TYPE.instantiate();
            try {
                try (TestElement external = (TestElement)TestElement.TYPE.instantiate();){
                    ((ExternalElementReferenceService)element.getExternalReference().service(ExternalElementReferenceService.class)).list(external.getItemList1());
                    this.testRefactoring(external.getItemList1(), element.getExternalReference());
                }
                if (element == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (element == null) throw throwable;
                element.close();
                throw throwable;
            }
            element.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testRefactoring(ElementList<TestElement.Item> list, ReferenceValue<String, TestElement.Item> reference) {
        String referenceLabel = reference.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
        PossibleValuesService possibleValuesService = (PossibleValuesService)reference.service(PossibleValuesService.class);
        TestElement.Item a = (TestElement.Item)list.insert();
        a.setName("a");
        TestElement.Item b = (TestElement.Item)list.insert();
        b.setName("b");
        TestElement.Item c = (TestElement.Item)list.insert();
        c.setName("c");
        TestElement.Item d = (TestElement.Item)list.insert();
        d.setName("d");
        reference.write((Object)"d");
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"dd", true);
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "dd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dd", (Object)reference.content());
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"ddd", false);
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "ddd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dd", (Object)reference.content());
        ElementReferenceTests.assertValidationError(reference, "Could not resolve " + referenceLabel + " \"dd\"");
        reference.write((Object)"ddd");
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"dddd", true);
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "dddd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dddd", (Object)reference.content());
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"ddddd");
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "ddddd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dddd", (Object)reference.content());
        ElementReferenceTests.assertValidationError(reference, "Could not resolve " + referenceLabel + " \"dddd\"");
    }
}

