/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.ui.def.loader;

import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.osgi.BundleBasedContext;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.junit.Test;
import org.osgi.framework.Bundle;

public final class DefinitionLoaderTests
extends SapphireTestCase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testCacheInClassContext() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            DefinitionLoader.Reference h1 = DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("TestDefinition").dialog();
            try {
                try (DefinitionLoader.Reference h2 = DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("TestDefinition").dialog();){
                    DefinitionLoaderTests.assertSame((Object)h1.resolve(), (Object)h2.resolve());
                }
                if (h1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (h1 == null) throw throwable;
                h1.close();
                throw throwable;
            }
            h1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testCacheInClassLoaderContext() {
        Class<?> cl = ((Object)((Object)this)).getClass();
        ClassLoader cldr = cl.getClassLoader();
        String pkg = cl.getPackage().getName();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            DefinitionLoader.Reference h1 = DefinitionLoader.context((ClassLoader)cldr).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();
            try {
                try (DefinitionLoader.Reference h2 = DefinitionLoader.context((ClassLoader)cldr).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();){
                    DefinitionLoaderTests.assertSame((Object)h1.resolve(), (Object)h2.resolve());
                }
                if (h1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (h1 == null) throw throwable;
                h1.close();
                throw throwable;
            }
            h1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testCacheInBundleContext() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.sapphire.tests");
        Class<?> cl = ((Object)((Object)this)).getClass();
        String pkg = cl.getPackage().getName();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            DefinitionLoader.Reference h1 = DefinitionLoader.context((Context)BundleBasedContext.adapt((Bundle)bundle)).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();
            try {
                try (DefinitionLoader.Reference h2 = DefinitionLoader.context((Context)BundleBasedContext.adapt((Bundle)bundle)).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();){
                    DefinitionLoaderTests.assertSame((Object)h1.resolve(), (Object)h2.resolve());
                }
                if (h1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (h1 == null) throw throwable;
                h1.close();
                throw throwable;
            }
            h1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

