/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.ui.internal.l10n.ValidationUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;

public class MarkerConstraintDetailsHelper {
    private static ConstraintRegistry constraintRegistry = ConstraintRegistry.getInstance();
    private static final String BOLD_START = "<b>";
    private static final String BOLD_END = "</b>";
    static final String PLATFORM_NEWLINE = System.getProperty("line.separator");
    static final String ALSO_IN_CATEGORIES = String.valueOf(PLATFORM_NEWLINE) + PLATFORM_NEWLINE + ValidationUIMessages.prefs_constraints_also;
    static final String CONSTRAINT_DESCRIPTION_PATTERN = ValidationUIMessages.prefs_description_constraint;
    static final String ERROR_CONSTRAINT_DESCRIPTION_PATTERN = ValidationUIMessages.prefs_description_constraint_error;
    static final String NO_CONSTRAINT_DESCRIPTION = ValidationUIMessages.prefs_no_description_constraint;

    public static String formatConstraintDescription(String constraintId, List styles) {
        IConstraintDescriptor constraint = constraintRegistry.getDescriptor(constraintId);
        if (constraint == null) {
            return MarkerConstraintDetailsHelper.parseStyles(NO_CONSTRAINT_DESCRIPTION, styles);
        }
        String description = constraint.getDescription();
        if (description == null) {
            description = NO_CONSTRAINT_DESCRIPTION;
        }
        String messagePattern = constraint.isError() ? ERROR_CONSTRAINT_DESCRIPTION_PATTERN : CONSTRAINT_DESCRIPTION_PATTERN;
        String text = NLS.bind((String)messagePattern, (Object[])new Object[]{constraint.getId(), constraint.getEvaluationMode(), description, constraint.getSeverity()});
        return MarkerConstraintDetailsHelper.parseStyles(text, styles);
    }

    private static String getOtherCategories(Category selected, Collection categories) {
        StringBuffer result = new StringBuffer(64);
        result.append(ALSO_IN_CATEGORIES);
        for (Category next : categories) {
            if (next == selected) continue;
            result.append(PLATFORM_NEWLINE);
            result.append(next.getQualifiedName());
        }
        return result.toString();
    }

    private static String parseStyles(String text, List styles) {
        int pos = -1;
        int lastPos = 0;
        StringBuffer result = new StringBuffer(text.length());
        while (lastPos < text.length()) {
            pos = text.indexOf(BOLD_START, lastPos);
            if (pos < 0) break;
            result.append(text.substring(lastPos, pos));
            lastPos = pos + BOLD_START.length();
            pos = text.indexOf(BOLD_END, lastPos);
            if (pos < 0) {
                pos = text.length();
            }
            styles.add(new StyleRange(result.length(), pos - lastPos, null, null, 1));
            result.append(text.substring(lastPos, pos));
            lastPos = Math.min(pos + BOLD_END.length(), text.length());
        }
        result.append(text.substring(lastPos, text.length()));
        return result.toString();
    }
}

