/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.IField;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerList;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSelectionProviderAction;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MarkerTransfer;

public class ActionCopyMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private IField[] properties;

    public ActionCopyMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, MarkerMessages.copyAction_title);
        this.part = part;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    void setProperties(IField[] properties) {
        this.properties = properties;
    }

    public void run() {
        IMarker[] markers = this.getSelectedMarkers();
        this.setClipboard(markers, this.createMarkerReport(markers));
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(Util.allConcreteSelection(selection));
    }

    private void setClipboard(IMarker[] markers, String markerReport) {
        block5: {
            try {
                Transfer[] transferTypes;
                Object[] data;
                if (markerReport == null) {
                    data = new Object[]{markers};
                    transferTypes = new Transfer[]{MarkerTransfer.getInstance()};
                } else {
                    data = new Object[]{markers, markerReport};
                    transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                }
                this.clipboard.setContents(data, transferTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.part.getSite().getShell(), (String)MarkerMessages.CopyToClipboardProblemDialog_title, (String)MarkerMessages.CopyToClipboardProblemDialog_message)) break block5;
                this.setClipboard(markers, markerReport);
            }
        }
    }

    String createMarkerReport(IMarker[] rawMarkers) {
        ConcreteMarker[] markers;
        try {
            markers = MarkerList.createMarkers(rawMarkers);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)MarkerMessages.Error, null, (IStatus)e.getStatus());
            return "";
        }
        StringBuffer report = new StringBuffer();
        String NEWLINE = System.getProperty("line.separator");
        if (this.properties == null) {
            return null;
        }
        int i = 0;
        while (i < this.properties.length) {
            report.append(this.properties[i].getDescription());
            if (i == this.properties.length - 1) {
                report.append(NEWLINE);
            } else {
                report.append('\t');
            }
            ++i;
        }
        ConcreteMarker[] concreteMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            ConcreteMarker marker = concreteMarkerArray[n2];
            int j = 0;
            while (j < this.properties.length) {
                report.append(this.properties[j].getValue(marker));
                if (j == this.properties.length - 1) {
                    report.append(NEWLINE);
                } else {
                    report.append('\t');
                }
                ++j;
            }
            ++n2;
        }
        return report.toString();
    }
}

