/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.views.documentation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sphinx.platform.ui.views.documentation.DocumentationViewFormatterDescriptor;

public class DocumentationViewFormatterDescriptorRegistry {
    public static final DocumentationViewFormatterDescriptorRegistry INSTANCE = new DocumentationViewFormatterDescriptorRegistry();
    private static final String EXTENSION_POINT_DOCUMENTATION_VIEW_FORMATTERS = "org.eclipse.sphinx.platform.ui.documentationViewFormatters";
    private IExtensionRegistry extensionRegistry;
    private List<DocumentationViewFormatterDescriptor> docViewFormatterDescriptors = new ArrayList<DocumentationViewFormatterDescriptor>();
    protected Ordering<DocumentationViewFormatterDescriptor> docViewFormatterOrdering = new Ordering<DocumentationViewFormatterDescriptor>(){

        public int compare(DocumentationViewFormatterDescriptor left, DocumentationViewFormatterDescriptor right) {
            return Ints.compare((int)left.getPriority(), (int)right.getPriority());
        }
    };

    private DocumentationViewFormatterDescriptorRegistry() {
        this.initialize();
    }

    private void initialize() {
        IConfigurationElement[] iConfigurationElementArray = this.readContributedDocViewFormatters();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            this.docViewFormatterDescriptors.add(new DocumentationViewFormatterDescriptor(configurationElement));
            ++n2;
        }
    }

    private IExtensionRegistry getExtensionRegistry() {
        if (this.extensionRegistry == null) {
            this.extensionRegistry = Platform.getExtensionRegistry();
        }
        return this.extensionRegistry;
    }

    protected IConfigurationElement[] readContributedDocViewFormatters() {
        IExtensionRegistry extensionRegistry = this.getExtensionRegistry();
        if (extensionRegistry != null) {
            return extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_DOCUMENTATION_VIEW_FORMATTERS);
        }
        return new IConfigurationElement[0];
    }

    protected Iterable<DocumentationViewFormatterDescriptor> getApplicableDocViewFormatterFor(final Object selectedObject) {
        Iterable applicableDocViewFormatters = Iterables.filter((Iterable)Lists.newArrayList(this.docViewFormatterDescriptors), (Predicate)new Predicate<DocumentationViewFormatterDescriptor>(){

            public boolean apply(DocumentationViewFormatterDescriptor docViewFormatterDescriptor) {
                return docViewFormatterDescriptor.isApplicableFor(selectedObject);
            }
        });
        return applicableDocViewFormatters;
    }
}

