/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.wizards.pages;

import java.util.Collection;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.groups.IGroupListener;
import org.eclipse.sphinx.platform.ui.wizards.pages.AbstractWizardPage;
import org.eclipse.sphinx.xtendxpand.XpandEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.ui.groups.OutputGroup;
import org.eclipse.sphinx.xtendxpand.ui.groups.TemplateGroup;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtend.expression.TypeSystem;

public class XpandConfigurationPage
extends AbstractWizardPage {
    protected TemplateGroup templateGroup;
    protected OutputGroup outputGroup;
    protected EObject modelObject;
    protected TypeSystem typeSystem;
    protected OutletsPreference outletsPreference;
    protected ExtendedOutlet defaultOutlet;

    public XpandConfigurationPage(String pageName) {
        super(pageName);
    }

    public void init(EObject modelObject, TypeSystem typeSystem, OutletsPreference outletsPreference, ExtendedOutlet defaultOutlet) {
        Assert.isNotNull((Object)typeSystem);
        this.typeSystem = typeSystem;
        this.modelObject = modelObject;
        this.outletsPreference = outletsPreference;
        this.defaultOutlet = defaultOutlet;
    }

    protected Control doCreateControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        this.createPageContent(composite);
        return composite;
    }

    protected void createPageContent(Composite parent) {
        this.createTemplateGroup(parent);
        this.createOutputGroup(parent);
    }

    protected void createTemplateGroup(Composite parent) {
        this.templateGroup = new TemplateGroup(Messages.label_template, this.modelObject, this.typeSystem, this.getDialogSettings());
        this.templateGroup.createContent(parent, 3);
        this.templateGroup.addGroupListener(new IGroupListener(){

            public void groupChanged(IField field) {
                XpandConfigurationPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    protected void createOutputGroup(Composite parent) {
        this.outputGroup = new OutputGroup(Messages.label_output, this.modelObject, this.outletsPreference, this.defaultOutlet);
        this.outputGroup.createContent(parent, 3);
        this.outputGroup.addGroupListener(new IGroupListener(){

            public void groupChanged(IField field) {
                XpandConfigurationPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    protected String doGetDescription() throws MissingResourceException {
        return Messages.desc_config;
    }

    protected String doGetTitle() throws MissingResourceException {
        return Messages.title_launchGen;
    }

    protected boolean doIsPageComplete() {
        return this.templateGroup.isGroupComplete() && this.outputGroup.isGroupComplete();
    }

    protected IStatus doValidateRules() {
        return null;
    }

    public Collection<XpandEvaluationRequest> getXpandEvaluationRequests() {
        return this.templateGroup.getXpandEvaluationRequests();
    }

    public Collection<? extends ExtendedOutlet> getOutlets() {
        return this.outputGroup.getOutlets();
    }

    public void finish() {
        if (this.templateGroup != null) {
            this.templateGroup.saveGroupSettings();
        }
    }
}

