/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.properties;

import org.eclipse.emf.common.util.EList;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.Utils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtendedAnnotationType;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtensionFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultValueModifier {
    private static TypeDeclarationType declaration;
    private static boolean isInternalSchema;
    private static ExtendedAttributeType externalAnnotationAttribute;
    private static String DEFAULTVALUE_ANNOTATION;

    static {
        DEFAULTVALUE_ANNOTATION = "carnot:defaultValue";
    }

    public static void setDeclaration(TypeDeclarationType model) {
        declaration = model;
        isInternalSchema = TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)declaration);
        if (!isInternalSchema) {
            externalAnnotationAttribute = ExtendedAttributeUtil.getAttribute((Extensible)declaration, (String)"carnot:engine:resource:mapping:annotations");
        }
    }

    public static Object getValueForElement(XSDComponent element) {
        XSDAnnotation annotation;
        if (element instanceof XSDAttributeDeclaration) {
            XSDSimpleTypeDefinition typeDefinition = ((XSDAttributeDeclaration)element).getTypeDefinition();
            if (typeDefinition == null || typeDefinition.getComplexType() != null) {
                return null;
            }
            annotation = ((XSDAttributeDeclaration)element).getAnnotation();
        } else if (element instanceof XSDElementDeclaration) {
            XSDTypeDefinition typeDefinition = ((XSDElementDeclaration)element).getTypeDefinition();
            if (typeDefinition == null || typeDefinition.getComplexType() != null) {
                return null;
            }
            annotation = ((XSDElementDeclaration)element).getAnnotation();
        } else {
            return null;
        }
        if (annotation != null) {
            return DefaultValueModifier.getAnnotationValue(annotation);
        }
        return null;
    }

    public static synchronized void setOrRemoveAnnotation(Object element, Object value) {
        XSDAnnotation annotation;
        boolean removeAnnotation = false;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            removeAnnotation = true;
        }
        if (element instanceof XSDAttributeDeclaration) {
            annotation = ((XSDAttributeDeclaration)element).getAnnotation();
        } else if (element instanceof XSDElementDeclaration) {
            annotation = ((XSDElementDeclaration)element).getAnnotation();
        } else {
            return;
        }
        if (annotation == null && !removeAnnotation) {
            annotation = DefaultValueModifier.createAnnotation(element, value);
        }
        if (annotation != null) {
            DefaultValueModifier.modifyAnnotation(annotation, value, removeAnnotation, element);
        }
    }

    private static String getAnnotationValue(XSDAnnotation annotation) {
        Node defaultValueNode = null;
        Element appInfoElement = null;
        EList appInfos = annotation.getApplicationInformation();
        int i = 0;
        while (i < appInfos.size()) {
            appInfoElement = (Element)appInfos.get(i);
            defaultValueNode = DefaultValueModifier.getChild(appInfoElement);
            if (defaultValueNode != null) break;
            ++i;
        }
        if (defaultValueNode != null) {
            Node child = defaultValueNode.getFirstChild();
            while (child != null && child.getNodeType() != 3) {
                child = child.getNextSibling();
            }
            Text textNode = null;
            if (child != null) {
                textNode = (Text)child;
            }
            if (textNode != null) {
                return textNode.getNodeValue();
            }
        }
        return null;
    }

    private static void modifyAnnotation(XSDAnnotation annotation, Object value, boolean removeAnnotation, Object element) {
        Node defaultValueNode = null;
        Element appInfoElement = null;
        int childrenCounter = 0;
        EList appInfos = annotation.getApplicationInformation();
        if (appInfos.isEmpty() && !removeAnnotation) {
            appInfoElement = annotation.createApplicationInformation(null);
            appInfos.add(appInfoElement);
            annotation.getElement().appendChild(appInfoElement);
        } else {
            int i = 0;
            while (i < appInfos.size()) {
                appInfoElement = (Element)appInfos.get(i);
                if (removeAnnotation) {
                    childrenCounter = DefaultValueModifier.getChildren(appInfoElement);
                }
                if ((defaultValueNode = DefaultValueModifier.getChild(appInfoElement)) != null) break;
                ++i;
            }
        }
        if (removeAnnotation) {
            if (defaultValueNode != null) {
                if (childrenCounter == 1) {
                    if (isInternalSchema) {
                        if (element instanceof XSDAttributeDeclaration) {
                            ((XSDAttributeDeclaration)element).setAnnotation(null);
                        } else if (element instanceof XSDElementDeclaration) {
                            ((XSDElementDeclaration)element).setAnnotation(null);
                        }
                    } else if (externalAnnotationAttribute != null && (annotation = externalAnnotationAttribute.getExtendedAnnotation()) != null) {
                        declaration.setExtendedAttributes(null);
                    }
                } else {
                    appInfoElement.removeChild(defaultValueNode);
                }
            }
            return;
        }
        if (defaultValueNode != null) {
            Node child = defaultValueNode.getFirstChild();
            while (child != null && child.getNodeType() != 3) {
                child = child.getNextSibling();
            }
            Text textNode = null;
            if (child != null) {
                textNode = (Text)child;
            }
            if (textNode == null) {
                textNode = defaultValueNode.getOwnerDocument().createTextNode((String)value);
                defaultValueNode.appendChild(textNode);
            } else {
                textNode.setNodeValue((String)value);
            }
        } else {
            Text textNode = null;
            Document document = appInfoElement.getOwnerDocument();
            defaultValueNode = document.createElementNS("http://www.carnot.ag/workflowmodel/3.1/struct", DEFAULTVALUE_ANNOTATION);
            appInfoElement.appendChild(defaultValueNode);
            textNode = defaultValueNode.getOwnerDocument().createTextNode((String)value);
            defaultValueNode.appendChild(textNode);
        }
    }

    public static int getChildren(Element appInfoElement) {
        NodeList children = appInfoElement.getChildNodes();
        return children.getLength();
    }

    public static Node getChild(Element appInfoElement) {
        NodeList children = appInfoElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && Utils.getNodeName((Node)node).equals("defaultValue")) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private static XSDAnnotation createAnnotation(Object element, Object value) {
        XSDAnnotation annotation = null;
        if (isInternalSchema) {
            annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            if (element instanceof XSDAttributeDeclaration) {
                ((XSDAttributeDeclaration)element).setAnnotation(annotation);
            } else if (element instanceof XSDElementDeclaration) {
                ((XSDElementDeclaration)element).setAnnotation(annotation);
            }
        } else if (externalAnnotationAttribute != null && (annotation = externalAnnotationAttribute.getExtendedAnnotation()) == null) {
            annotation = ExtensionFactory.eINSTANCE.createExtendedAnnotationType();
            externalAnnotationAttribute.setExtendedAnnotation((ExtendedAnnotationType)annotation);
        }
        return annotation;
    }

    public static String getStringForElement(XSDComponent element) {
        Object value = DefaultValueModifier.getValueForElement(element);
        if (value != null) {
            return (String)value;
        }
        return null;
    }
}

