/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.properties;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IdFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.TableEditorTraverseManager;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.data.structured.StructContentProvider;
import org.eclipse.stardust.modeling.data.structured.StructLabelProvider;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.validation.util.FieldInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class SimpleTypePropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final String NEW_ELEMENT_PLACEHOLDER = Structured_Messages.SimpleTypePropertyPage_NewFacetPlaceholder;
    private TableViewer viewer;
    private StructLabelProvider labelProvider;
    private StructContentProvider contentProvider;
    private Button deleteButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private TypeDeclarationType declaration;
    private XSDSimpleTypeDefinition type;
    private Text maxLengthText;
    private Text minLengthText;
    private Button enumerationRadioButton;
    private Button patternedRadioButton;
    private Button javaEnumRadioButton;
    private Label baseTypeLabel;
    private Label maxLengthLabel;
    private Label minLengthLabel;
    private LabeledText classText;
    private TypeSelectionComposite classBrowser;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent ev) {
            SimpleTypePropertyPage.this.removeEnumerations();
            TypeInfo itype = SimpleTypePropertyPage.this.classBrowser.getType();
            if (itype != null) {
                SimpleTypePropertyPage.this.setJavaType(itype);
            }
            SimpleTypePropertyPage.this.viewer.refresh();
            SimpleTypePropertyPage.this.validateClass();
        }
    };
    private TypeFinder finder;
    private String enumName;

    public void performDefaults() {
        this.type = TypeDeclarationUtils.getSimpleType((TypeDeclarationType)this.declaration);
        this.setRadioButtons(this.type);
        try {
            super.performDefaults();
        }
        catch (Exception exception) {}
        this.viewer.refresh((Object)this.getModelElement());
        this.validateAll();
    }

    public static final boolean isNewType(XSDConstrainingFacet candidate) {
        return NEW_ELEMENT_PLACEHOLDER == candidate.getLexicalValue();
    }

    public void apply() {
    }

    public void elementChanged() {
        XSDMinLengthFacet minLength;
        this.declaration = (TypeDeclarationType)this.getElement().getAdapter(EObject.class);
        this.type = TypeDeclarationUtils.getSimpleType((TypeDeclarationType)this.declaration);
        this.finder = new TypeFinder((EObject)this.declaration);
        this.classBrowser.setTypeFinder(this.finder);
        this.classBrowser.setModel((ModelType)this.declaration.eContainer().eContainer());
        this.classBrowser.setFilter(Enum.class);
        String namespace = this.type.getTargetNamespace();
        XSDTypeDefinition baseType = this.type.getBaseType();
        String label = baseType.getName();
        namespace = baseType.getTargetNamespace();
        if (namespace != null && namespace.trim().length() > 0) {
            label = String.valueOf(label) + " (" + namespace + ")";
        }
        this.baseTypeLabel.setText(label);
        XSDMaxLengthFacet maxLength = this.type.getMaxLengthFacet();
        if (maxLength != null) {
            this.maxLengthText.setText(new Integer(maxLength.getValue()).toString());
        }
        if ((minLength = this.type.getMinLengthFacet()) != null) {
            this.minLengthText.setText(new Integer(minLength.getValue()).toString());
        }
        this.setRadioButtons(this.type);
        boolean isInternal = TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)this.declaration);
        boolean javaBound = this.isJavaBound();
        if (isInternal && !javaBound) {
            this.contentProvider.setNewElement(this.type, this.createNewElement());
        }
        this.enumerationRadioButton.setEnabled(this.enumerationRadioButton.getSelection() || isInternal);
        this.patternedRadioButton.setEnabled(this.patternedRadioButton.getSelection() || isInternal);
        this.javaEnumRadioButton.setEnabled(this.javaEnumRadioButton.getSelection() || isInternal);
        this.minLengthText.setEditable(isInternal);
        this.maxLengthText.setEditable(isInternal);
        this.viewer.setInput((Object)this.declaration);
        this.updateButtons();
        this.setJavaBound(javaBound);
        if (javaBound) {
            this.enumName = ExtendedAttributeUtil.getAttributeValue((Extensible)this.declaration, (String)"carnot:engine:className");
            this.initJavaType(this.enumName);
        }
        this.validateClass();
    }

    private void initJavaType(String enumName) {
        TypeInfo enumType = this.finder.findType(enumName);
        if (enumType == null) {
            this.classBrowser.setTypeText(enumName);
        } else {
            this.classBrowser.setType(enumType);
        }
    }

    private void setRadioButtons(XSDSimpleTypeDefinition type) {
        if (this.isJavaBound()) {
            this.javaEnumRadioButton.setSelection(true);
            this.enumerationRadioButton.setSelection(false);
            this.patternedRadioButton.setSelection(false);
        } else if (type.getPatternFacets().isEmpty() || !type.getEnumerationFacets().isEmpty()) {
            this.enumerationRadioButton.setSelection(true);
            this.patternedRadioButton.setSelection(false);
            this.javaEnumRadioButton.setSelection(false);
        } else {
            this.patternedRadioButton.setSelection(true);
            this.enumerationRadioButton.setSelection(false);
            this.javaEnumRadioButton.setSelection(false);
        }
    }

    private XSDConstrainingFacet createNewElement() {
        XSDPatternFacet facet = this.patternedRadioButton.getSelection() ? XSDFactory.eINSTANCE.createXSDPatternFacet() : XSDFactory.eINSTANCE.createXSDEnumerationFacet();
        facet.setLexicalValue(NEW_ELEMENT_PLACEHOLDER);
        return facet;
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)4);
        FormBuilder.createLabel((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_BaseTypeLabel);
        this.baseTypeLabel = FormBuilder.createLabel((Composite)composite, (String)"", (int)3);
        FormBuilder.createLabel((Composite)composite, (String)"");
        this.enumerationRadioButton = FormBuilder.createRadioButton((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_EnumerationButtonLabel);
        this.patternedRadioButton = FormBuilder.createRadioButton((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_PatternedButtonLabel);
        this.javaEnumRadioButton = FormBuilder.createRadioButton((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_JavaBound);
        this.maxLengthLabel = FormBuilder.createLabel((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_MaxLengthLabel);
        this.maxLengthText = FormBuilder.createText((Composite)composite, (int)3);
        this.minLengthLabel = FormBuilder.createLabel((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_MinLengthLabel);
        this.minLengthText = FormBuilder.createText((Composite)composite, (int)3);
        LabelWithStatus classLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_EnumClass);
        this.classBrowser = new TypeSelectionComposite(composite, Structured_Messages.SimpleTypePropertyPage_JavaEnumClass, 3);
        this.classText = new LabeledText(this.classBrowser.getText(), classLabel);
        this.exclude(true, new Control[]{this.classBrowser.getText().getParent(), this.classText.getLabel()});
        Table table = FormBuilder.createTable((Composite)composite, (int)67588, (String[])StructLabelProvider.SIMPLE_TYPE_COLUMNS, (int[])new int[]{99}, (int)4);
        table.setHeaderVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.labelProvider = new StructLabelProvider();
        this.contentProvider = new StructContentProvider(false);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setColumnProperties(StructLabelProvider.SIMPLE_TYPE_COLUMNS);
        this.enumerationRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SimpleTypePropertyPage.this.enumerationRadioButton.getSelection()) {
                    SimpleTypePropertyPage.this.removePatterns();
                    if (TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)SimpleTypePropertyPage.this.declaration)) {
                        SimpleTypePropertyPage.this.contentProvider.setNewElement(SimpleTypePropertyPage.this.type, SimpleTypePropertyPage.this.createNewElement());
                    }
                    SimpleTypePropertyPage.this.setJavaBound(false);
                    SimpleTypePropertyPage.this.viewer.refresh();
                }
            }
        });
        this.patternedRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SimpleTypePropertyPage.this.patternedRadioButton.getSelection()) {
                    SimpleTypePropertyPage.this.removeEnumerations();
                    if (TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)SimpleTypePropertyPage.this.declaration)) {
                        SimpleTypePropertyPage.this.contentProvider.setNewElement(SimpleTypePropertyPage.this.type, SimpleTypePropertyPage.this.createNewElement());
                    }
                    SimpleTypePropertyPage.this.setJavaBound(false);
                    SimpleTypePropertyPage.this.viewer.refresh();
                }
            }
        });
        this.javaEnumRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SimpleTypePropertyPage.this.javaEnumRadioButton.getSelection()) {
                    SimpleTypePropertyPage.this.removePatterns();
                    SimpleTypePropertyPage.this.removeEnumerations();
                    SimpleTypePropertyPage.this.contentProvider.removeNewElement(SimpleTypePropertyPage.this.type);
                    SimpleTypePropertyPage.this.setJavaBound(true);
                    SimpleTypePropertyPage.this.viewer.refresh();
                    SimpleTypePropertyPage.this.validateClass();
                }
            }
        });
        this.maxLengthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleTypePropertyPage.this.updateMaxLength();
            }
        });
        this.minLengthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleTypePropertyPage.this.updateMinLength();
            }
        });
        this.viewer.setCellModifier((ICellModifier)new Modifier());
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Object[] elements;
                ISelection selection = SimpleTypePropertyPage.this.viewer.getSelection();
                if (selection.isEmpty() && (elements = SimpleTypePropertyPage.this.contentProvider.getElements(SimpleTypePropertyPage.this.viewer.getInput())).length > 0) {
                    SimpleTypePropertyPage.this.viewer.setSelection((ISelection)new StructuredSelection(elements[0]));
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        table.addTraverseListener((TraverseListener)new TableEditorTraverseManager(this.viewer, -1, 0, 0, 0));
        final TextCellEditor nameEditor = new TextCellEditor((Composite)table);
        nameEditor.getControl().addTraverseListener((TraverseListener)new TableEditorTraverseManager(this.viewer, -3, -2, 0, 0){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8 || !SimpleTypePropertyPage.isNewType((XSDConstrainingFacet)((IStructuredSelection)SimpleTypePropertyPage.this.viewer.getSelection()).getFirstElement()) || nameEditor.isDirty()) {
                    super.keyTraversed(e);
                }
            }

            public Object getPreviousElement(Object selection) {
                Object[] elements = SimpleTypePropertyPage.this.contentProvider.getElements(SimpleTypePropertyPage.this.viewer.getInput());
                int i = 1;
                while (i < elements.length) {
                    if (elements[i].equals(selection)) {
                        return elements[i - 1];
                    }
                    ++i;
                }
                return null;
            }

            public Object getNextElement(Object selection) {
                XSDConstrainingFacet adapter = (XSDConstrainingFacet)selection;
                if (SimpleTypePropertyPage.isNewType(adapter)) {
                    SimpleTypePropertyPage.this.addEntry(adapter, (String)nameEditor.getValue());
                }
                Object[] elements = SimpleTypePropertyPage.this.contentProvider.getElements(SimpleTypePropertyPage.this.viewer.getInput());
                int i = 0;
                while (i < elements.length - 1) {
                    if (elements[i].equals(selection)) {
                        return elements[i + 1];
                    }
                    ++i;
                }
                return null;
            }
        });
        this.viewer.setCellEditors(new CellEditor[]{nameEditor});
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleTypePropertyPage.this.updateButtons();
            }
        });
        return composite;
    }

    private void exclude(boolean exclude, Control ... controls) {
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                GridData gd = (GridData)control.getLayoutData();
                gd.exclude = exclude;
                control.setVisible(!exclude);
                ++n2;
            }
        }
    }

    protected void removeEnumerations() {
        EList enumerations = this.type.getEnumerationFacets();
        int i = enumerations.size() - 1;
        while (i >= 0) {
            this.type.getFacetContents().remove(enumerations.get(i));
            --i;
        }
    }

    protected void removePatterns() {
        EList patterns = this.type.getPatternFacets();
        int i = patterns.size() - 1;
        while (i >= 0) {
            this.type.getFacetContents().remove(patterns.get(i));
            --i;
        }
    }

    protected void updateButtons() {
        IStructuredSelection iss;
        boolean isInternal;
        boolean bl = isInternal = TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)this.declaration) && !this.isJavaBound();
        if (!isInternal) {
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            return;
        }
        boolean isFacet = false;
        boolean isFirst = true;
        boolean isLast = true;
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (iss = (IStructuredSelection)selection).getFirstElement() instanceof XSDConstrainingFacet && !SimpleTypePropertyPage.isNewType((XSDConstrainingFacet)iss.getFirstElement())) {
            isFacet = true;
            XSDConstrainingFacet element = (XSDConstrainingFacet)iss.getFirstElement();
            Object[] children = this.contentProvider.getChildren(element.getSimpleTypeDefinition());
            if (children.length > 0) {
                isFirst = element == children[0];
                isLast = element == children[children.length - 2];
            }
        }
        this.deleteButton.setEnabled(isFacet);
        this.moveUpButton.setEnabled(!isFirst);
        this.moveDownButton.setEnabled(!isLast);
    }

    private boolean isJavaBound() {
        return ExtendedAttributeUtil.getAttribute((Extensible)this.declaration, (String)"carnot:engine:className") != null;
    }

    protected void updateMaxLength() {
        String stringValue = this.maxLengthText.getText().trim();
        long longValue = -1L;
        try {
            longValue = Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {}
        XSDMaxLengthFacet maxLength = this.type.getMaxLengthFacet();
        if (longValue < 0L) {
            if (maxLength != null) {
                this.type.getFacetContents().remove((Object)maxLength);
            }
        } else {
            if (maxLength == null) {
                maxLength = XSDFactory.eINSTANCE.createXSDMaxLengthFacet();
                this.type.getFacetContents().add((Object)maxLength);
            }
            maxLength.setLexicalValue(Long.toString(longValue));
        }
        this.validateAll();
    }

    protected void updateMinLength() {
        String stringValue = this.minLengthText.getText().trim();
        long longValue = -1L;
        try {
            longValue = Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {}
        XSDMinLengthFacet minLength = this.type.getMinLengthFacet();
        if (longValue < 0L) {
            if (minLength != null) {
                this.type.getFacetContents().remove((Object)minLength);
            }
        } else {
            if (minLength == null) {
                minLength = XSDFactory.eINSTANCE.createXSDMinLengthFacet();
                this.type.getFacetContents().add((Object)minLength);
            }
            minLength.setLexicalValue(Long.toString(longValue));
        }
        this.validateAll();
    }

    private void validateAll() {
        this.validateLength();
        if (this.isValid()) {
            this.validateInput();
        }
        if (this.isValid()) {
            this.validateClass();
        }
    }

    private void validateClass() {
        if (ExtendedAttributeUtil.getAttribute((Extensible)this.declaration, (String)"carnot:engine:className") != null) {
            TypeFinder finder;
            TypeInfo type;
            ModelType model = ModelUtils.findContainingModel((EObject)this.declaration);
            String className = ExtendedAttributeUtil.getAttributeValue((Extensible)this.declaration, (String)"carnot:engine:className");
            if (StringUtils.isEmpty((String)className)) {
                this.setMessage(Structured_Messages.ERROR_MSG_NO_CLASSNAME, 3);
                this.setValid(false);
                return;
            }
            if (model != null && (type = (finder = new TypeFinder((EObject)model)).findType(className)) == null && TypeFinder.getProjectFromEObject((EObject)model) != null) {
                this.setMessage(MessageFormat.format(Structured_Messages.ERROR_MSG_INVALID_CLASSNAME, className), 3);
                this.setValid(false);
                return;
            }
        }
        this.setMessage(null);
        this.setValid(true);
    }

    private void validateLength() {
        String minLengthString = this.minLengthText.getText().trim();
        String maxLengthString = this.maxLengthText.getText().trim();
        if (StringUtils.isEmpty((String)maxLengthString) && StringUtils.isEmpty((String)minLengthString)) {
            this.setMessage(null);
            this.setValid(true);
            return;
        }
        long maxLengthValue = 0L;
        if (!StringUtils.isEmpty((String)maxLengthString)) {
            try {
                maxLengthValue = Long.parseLong(maxLengthString);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(Structured_Messages.SimpleTypePropertyPage_MaxLengthLongValue, 3);
                this.setValid(false);
                return;
            }
            if (maxLengthValue < 0L) {
                this.setMessage(Structured_Messages.SimpleTypePropertyPage_MaxLengthLongValue, 3);
                this.setValid(false);
                return;
            }
        }
        long minLengthValue = 0L;
        if (!StringUtils.isEmpty((String)minLengthString)) {
            try {
                minLengthValue = Long.parseLong(minLengthString);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(Structured_Messages.SimpleTypePropertyPage_MinLengthLongValue, 3);
                this.setValid(false);
                return;
            }
            if (minLengthValue < 0L) {
                this.setMessage(Structured_Messages.SimpleTypePropertyPage_MinLengthLongValue, 3);
                this.setValid(false);
                return;
            }
        }
        if (maxLengthValue < minLengthValue) {
            this.setMessage(Structured_Messages.SimpleTypePropertyPage_InvalidLengthMessage, 3);
            this.setValid(false);
            return;
        }
        this.setMessage(null);
        this.setValid(true);
    }

    private void validateInput() {
        Object[] children = this.contentProvider.getChildren(this.type);
        HashSet<String> usedValues = new HashSet<String>();
        int i = 0;
        while (i < children.length) {
            XSDConstrainingFacet element = (XSDConstrainingFacet)children[i];
            String value = element.getLexicalValue();
            if (usedValues.contains(value)) {
                this.setMessage(MessageFormat.format(Structured_Messages.SimpleTypePropertyPage_DuplicateValueMessage, value), 3);
                this.setValid(false);
                return;
            }
            usedValues.add(value);
            ++i;
        }
        this.setMessage(null);
        this.setValid(true);
    }

    public void contributeVerticalButtons(Composite parent) {
        this.deleteButton = FormBuilder.createButton((Composite)parent, (String)Structured_Messages.DeleteButtonLabel, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimpleTypePropertyPage.this.deleteField();
            }
        });
        this.moveUpButton = FormBuilder.createButton((Composite)parent, (String)Structured_Messages.MoveUpButtonLabel, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimpleTypePropertyPage.this.moveFieldUp();
            }
        });
        this.moveDownButton = FormBuilder.createButton((Composite)parent, (String)Structured_Messages.MoveDownButtonLabel, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimpleTypePropertyPage.this.moveFieldDown();
            }
        });
    }

    protected void moveFieldDown() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        XSDConstrainingFacet facet = (XSDConstrainingFacet)selection.getFirstElement();
        EList list = this.enumerationRadioButton.getSelection() ? this.type.getEnumerationFacets() : this.type.getPatternFacets();
        int index = list.indexOf(facet);
        XSDConstrainingFacet[] elements = list.toArray(new XSDConstrainingFacet[list.size()]);
        int i = elements.length - 1;
        while (i >= index) {
            this.remove(elements[i]);
            --i;
        }
        this.add(elements[index + 1]);
        this.add(elements[index]);
        i = index + 2;
        while (i < elements.length) {
            this.add(elements[i]);
            ++i;
        }
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)selection);
    }

    private void remove(XSDConstrainingFacet facet) {
        if (facet instanceof XSDEnumerationFacet || facet instanceof XSDPatternFacet) {
            this.type.getFacetContents().remove((Object)facet);
        }
    }

    private void add(XSDConstrainingFacet facet) {
        if (facet instanceof XSDEnumerationFacet || facet instanceof XSDPatternFacet) {
            this.type.getFacetContents().add((Object)facet);
        }
    }

    protected void moveFieldUp() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        XSDConstrainingFacet facet = (XSDConstrainingFacet)selection.getFirstElement();
        EList list = this.enumerationRadioButton.getSelection() ? this.type.getEnumerationFacets() : this.type.getPatternFacets();
        int index = list.indexOf(facet);
        XSDConstrainingFacet[] elements = list.toArray(new XSDConstrainingFacet[list.size()]);
        int i = elements.length - 1;
        while (i >= index - 1) {
            this.remove(elements[i]);
            --i;
        }
        this.add(elements[index]);
        this.add(elements[index - 1]);
        i = index + 1;
        while (i < elements.length) {
            this.add(elements[i]);
            ++i;
        }
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)selection);
    }

    protected void deleteField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        XSDConstrainingFacet facet = (XSDConstrainingFacet)selection.getFirstElement();
        this.remove(facet);
        this.viewer.refresh();
        this.validateAll();
    }

    private void addEntry(XSDConstrainingFacet current, String value) {
        this.contentProvider.setNewElement(this.type, this.createNewElement());
        current.setLexicalValue(value);
        this.add(current);
        this.viewer.refresh();
        this.updateButtons();
    }

    private void setJavaBound(boolean bound) {
        if (bound) {
            this.maxLengthText.setText("");
            this.minLengthText.setText("");
            if (!this.isJavaBound()) {
                ExtendedAttributeUtil.createAttribute((Extensible)this.declaration, (String)"carnot:engine:className");
            }
            this.classBrowser.getText().addModifyListener(this.listener);
            if (this.enumName != null) {
                this.initJavaType(this.enumName);
            }
        } else {
            ExtendedAttributeUtil.setAttribute((Extensible)this.declaration, (String)"carnot:engine:className", null);
            this.classBrowser.getText().removeModifyListener(this.listener);
            this.classBrowser.setType(null);
        }
        this.exclude(bound, new Control[]{this.maxLengthLabel, this.minLengthLabel, this.maxLengthText, this.minLengthText});
        this.exclude(!bound, new Control[]{this.classBrowser.getText().getParent(), this.classText.getLabel()});
        this.minLengthText.getParent().layout();
    }

    private void setJavaType(TypeInfo itype) {
        this.enumName = itype.getFullName();
        int ix = this.enumName.lastIndexOf(46);
        String name = ix >= 0 ? this.enumName.substring(ix + 1) : this.enumName;
        ix = name.lastIndexOf(36);
        name = ix >= 0 ? name.substring(ix + 1) : name;
        IdFactory factory = new IdFactory(null, name, XpdlPackage.eINSTANCE.getTypeDeclarationType(), (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getTypeDeclarationType_Name());
        TypeDeclarationsType container = (TypeDeclarationsType)this.declaration.eContainer();
        List declarations = CollectionUtils.copyList((List)container.getTypeDeclaration());
        declarations.remove(this.declaration);
        factory.computeNames(declarations, false);
        String oldName = ExtendedAttributeUtil.getAttributeValue((Extensible)this.declaration, (String)"carnot:engine:className");
        String newId = factory.getId();
        String newName = factory.getName();
        if (!(newId.equals(this.declaration.getId()) || !StringUtils.isEmpty((String)oldName) && oldName.equals(this.enumName))) {
            this.declaration.setId(newId);
        }
        if (!(newName.equals(this.declaration.getName()) || !StringUtils.isEmpty((String)oldName) && oldName.equals(this.enumName))) {
            this.declaration.setName(newName);
        }
        ExtendedAttributeUtil.setAttribute((Extensible)this.declaration, (String)"carnot:engine:className", (String)this.enumName);
        try {
            for (FieldInfo field : itype.getFields()) {
                if (!field.isEnum()) continue;
                XSDConstrainingFacet item = this.createNewElement();
                item.setLexicalValue(field.getFieldName());
                this.add(item);
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
    }

    private class Modifier
    implements ICellModifier {
        private Modifier() {
        }

        public boolean canModify(Object element, String property) {
            return !SimpleTypePropertyPage.this.isJavaBound() && TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)SimpleTypePropertyPage.this.declaration);
        }

        public Object getValue(Object element, String property) {
            XSDConstrainingFacet entry = (XSDConstrainingFacet)element;
            return entry.getLexicalValue();
        }

        public void modify(Object element, String property, Object newValue) {
            XSDConstrainingFacet entry;
            String oldValue;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (!(oldValue = (entry = (XSDConstrainingFacet)element).getLexicalValue()).equals(newValue = ((String)newValue).trim())) {
                if (SimpleTypePropertyPage.isNewType(entry)) {
                    SimpleTypePropertyPage.this.addEntry(entry, (String)newValue);
                } else {
                    entry.setLexicalValue((String)newValue);
                    SimpleTypePropertyPage.this.viewer.update((Object)entry, StructLabelProvider.SIMPLE_TYPE_COLUMNS);
                }
                SimpleTypePropertyPage.this.validateAll();
            }
        }
    }
}

