/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.validation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.engine.core.model.beans.QNameUtil;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.util.PathEntry;

public class StructBridgeObject
extends BridgeObject {
    protected String actualTypeName;
    private String label;
    protected boolean isList;

    public StructBridgeObject(IType accessPointType, DirectionType direction, PathEntry entry) {
        super(accessPointType, direction);
        String[] labels = StructBridgeObject.computeActualTypeName(entry);
        this.label = labels[0];
        this.actualTypeName = labels[1];
        this.isList = StructBridgeObject.isList(entry);
    }

    public boolean acceptAssignmentFrom(BridgeObject rhs) {
        if (rhs instanceof StructBridgeObject) {
            StructBridgeObject other = (StructBridgeObject)rhs;
            if (this.actualTypeName != null && other.actualTypeName != null) {
                return this.actualTypeName.equals(other.actualTypeName) || this.isList;
            }
        }
        return this.isList || super.acceptAssignmentFrom(rhs);
    }

    public static String[] computeActualTypeName(PathEntry entry) {
        TypeDeclarationType declaration;
        String[] result = new String[2];
        ITypedElement element = entry.getElement();
        if (element instanceof StructAccessPointType) {
            StructAccessPointType struct = (StructAccessPointType)element;
            TypedXPath xpath = struct.getXPath();
            if (xpath == null) {
                result[0] = "";
                result[1] = "";
                return result;
            }
            result[0] = xpath.getXsdElementName();
            result[1] = QNameUtil.toString((String)xpath.getXsdElementNs(), (String)xpath.getXsdElementName());
        } else if ((element instanceof DataType || element instanceof AccessPointType) && (declaration = StructBridgeObject.findTypeDeclaration(element)) != null) {
            XpdlTypeType dataType = declaration.getDataType();
            if (dataType instanceof ExternalReferenceType) {
                ExternalReferenceType ref = (ExternalReferenceType)dataType;
                result[0] = QNameUtil.parseLocalName((String)ref.getXref());
                result[1] = ref.getXref();
            } else if (dataType instanceof SchemaTypeType) {
                IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)declaration);
                result[0] = xPathMap.getRootXPath().getXsdElementName();
                result[1] = QNameUtil.toString((String)xPathMap.getRootXPath().getXsdElementNs(), (String)xPathMap.getRootXPath().getXsdElementName());
            }
        }
        return result;
    }

    public static boolean isList(PathEntry entry) {
        TypeDeclarationType declaration;
        ITypedElement element = entry.getElement();
        if (element instanceof StructAccessPointType) {
            StructAccessPointType struct = (StructAccessPointType)element;
            TypedXPath xpath = struct.getXPath();
            return xpath.isList();
        }
        if ((element instanceof DataType || element instanceof AccessPointType) && (declaration = StructBridgeObject.findTypeDeclaration(element)) != null) {
            try {
                IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)declaration);
                return xPathMap.getRootXPath().isList();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected static TypeDeclarationType findTypeDeclaration(ITypedElement element) {
        ModelType model;
        ExternalReferenceType ref;
        TypeDeclarationType declaration = null;
        if (element instanceof DataType && (ref = ((DataType)element).getExternalReference()) != null) {
            TypeDeclarationsType declarations;
            ModelType externalModel;
            model = ModelUtils.findContainingModel((EObject)((DataType)element));
            ExternalPackages packages = model.getExternalPackages();
            ExternalPackage pkg = packages == null ? null : packages.getExternalPackage(ref.getLocation());
            IConnectionManager manager = model.getConnectionManager();
            ModelType modelType = externalModel = manager == null ? null : manager.find(pkg);
            if (externalModel != null && (declarations = externalModel.getTypeDeclarations()) != null) {
                declaration = declarations.getTypeDeclaration(ref.getXref());
            }
        }
        if (declaration == null) {
            declaration = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataType");
        }
        if (declaration == null) {
            TypeDeclarationsType typeDeclarations;
            String typeDeclarationId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataType");
            model = ModelUtils.findContainingModel((EObject)element);
            if (model != null && (typeDeclarations = model.getTypeDeclarations()) != null) {
                declaration = typeDeclarations.getTypeDeclaration(typeDeclarationId);
            }
        }
        return declaration;
    }

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        return super.toString();
    }
}

