/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectSingleFolderView {
    protected Composite composite;
    protected IStructuredSelection selection;
    protected boolean isFolderMandatory;
    protected TreeViewer sourceFileViewer;
    protected IFolder selectedFolder;
    protected ISelection defaultSelection;
    protected Listener listener;
    private IJavaProject javaProject;

    public SelectSingleFolderView(IStructuredSelection selection, boolean isFileMandatory, IProject project) {
        this.selection = selection;
        this.isFolderMandatory = isFileMandatory;
        this.selectedFolder = null;
        this.defaultSelection = null;
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                this.javaProject = JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Composite createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(1808));
        Composite smallComposite = new Composite(this.composite, 0);
        smallComposite.setLayoutData((Object)new GridData(4, 256, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        smallComposite.setLayout((Layout)gridLayout);
        Label label = new Label(smallComposite, 0);
        label.setText(Structured_Messages.SelectSaveLocationLabel);
        label.setLayoutData((Object)new GridData(32, 3, false, false));
        ToolBar toolBar = new ToolBar(smallComposite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(3, 3, true, false));
        ToolItem toolItem = new ToolItem(toolBar, 0);
        ImageDescriptor imageDescriptor = DiagramPlugin.getImageDescriptor((String)"{org.eclipse.wst.common.ui}icons/expandAll.gif");
        Image image = imageDescriptor.createImage();
        toolItem.setImage(image);
        toolItem.setToolTipText(Structured_Messages.ExpandAllLabel);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectSingleFolderView.this.sourceFileViewer.expandAll();
            }
        });
        toolItem = new ToolItem(toolBar, 0);
        imageDescriptor = DiagramPlugin.getImageDescriptor((String)"{org.eclipse.wst.common.ui}icons/collapseAll.gif");
        image = imageDescriptor.createImage();
        toolItem.setImage(image);
        toolItem.setToolTipText(Structured_Messages.CollapseAllLabel);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectSingleFolderView.this.sourceFileViewer.collapseAll();
            }
        });
        this.createSourceViewer(this.composite);
        this.sourceFileViewer.getTree().setFocus();
        return this.composite;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void createSourceViewer(Composite parent) {
        this.sourceFileViewer = new TreeViewer(new Tree(parent, 2052));
        this.sourceFileViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof IJavaProject) {
                    List result = CollectionUtils.newList();
                    try {
                        IPackageFragmentRoot[] roots = SelectSingleFolderView.this.javaProject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            IResource resource = roots[i].getCorrespondingResource();
                            if (resource instanceof IFolder) {
                                result.add(resource);
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    return result.toArray();
                }
                return super.getChildren(element);
            }
        });
        this.sourceFileViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sourceFileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isComplete = true;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    for (IResource resource : list) {
                        if (resource instanceof IFolder) {
                            SelectSingleFolderView.this.selectedFolder = (IFolder)resource;
                            if (!SelectSingleFolderView.this.isFolderMandatory) continue;
                            isComplete = true;
                            break;
                        }
                        SelectSingleFolderView.this.selectedFolder = null;
                        if (!SelectSingleFolderView.this.isFolderMandatory) continue;
                        isComplete = false;
                    }
                    if (SelectSingleFolderView.this.listener != null) {
                        SelectSingleFolderView.this.listener.setControlComplete(isComplete);
                    }
                }
            }
        });
        this.sourceFileViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IContainer;
            }
        });
        Tree treeWidget = this.sourceFileViewer.getTree();
        GridData gd = new GridData(1808);
        treeWidget.setLayoutData((Object)gd);
    }

    public IFolder getFolder() {
        return this.selectedFolder;
    }

    public void setDefaultSelection(ISelection selection) {
        this.defaultSelection = selection;
    }

    public void setVisibleHelper(boolean visible) {
        if (visible) {
            this.sourceFileViewer.setInput(this.javaProject == null ? ResourcesPlugin.getWorkspace().getRoot() : this.javaProject);
            this.sourceFileViewer.expandToLevel(1);
            if (this.defaultSelection != null) {
                this.sourceFileViewer.setSelection(this.defaultSelection, true);
            } else if (!this.sourceFileViewer.getSelection().isEmpty()) {
                this.sourceFileViewer.setSelection(this.sourceFileViewer.getSelection());
            } else if (this.isFolderMandatory && this.listener != null) {
                this.listener.setControlComplete(false);
            }
        }
        this.composite.setVisible(visible);
    }

    public void addSelectionChangedTreeListener(ISelectionChangedListener treeListener) {
        this.sourceFileViewer.addSelectionChangedListener(treeListener);
    }

    public String getClasspathResourceName(IFile file) {
        return GenericUtils.getLocationRelativeToClasspath((IFile)file);
    }

    public static interface Listener {
        public void setControlComplete(boolean var1);
    }
}

