/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.modeling.debug.debugger.types.IJavaTypeValue;

public abstract class AbstractJavaTypeValue
implements IJavaTypeValue {
    private String refTypeName;
    private IVariable associatedVariable;
    private IVariable writeBackVariable;
    private IValue value;

    protected AbstractJavaTypeValue(IVariable variable) {
        try {
            this.associatedVariable = variable;
            this.writeBackVariable = variable;
            this.value = variable == null ? null : variable.getValue();
            this.refTypeName = this.value != null ? this.value.getReferenceTypeName() : "";
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    @Override
    public String getVariableName() {
        try {
            return this.associatedVariable.getName();
        }
        catch (DebugException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public IVariable getAssociatedVariable() {
        return this.associatedVariable;
    }

    @Override
    public String getRefTypeName() {
        return this.refTypeName;
    }

    @Override
    public IVariable getWritebackVariable() {
        return this.writeBackVariable;
    }

    @Override
    public void setWritebackVariable(IVariable variable) {
        this.writeBackVariable = variable;
    }
}

