/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.stardust.common.Money;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.engine.core.struct.ClientXPathMap;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataConverter;
import org.eclipse.stardust.engine.core.struct.StructuredTypeRtUtils;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.PrimitivesFactory;
import org.eclipse.stardust.modeling.debug.model.JavaVariableDecorator;

public class DataField
extends AbstractJavaTypeValue {
    private static final Logger trace = LogManager.getLogger(DataField.class);
    private DataHolder dataHolder;
    private String name;
    private String typeName;
    private String evaluatedValue;
    private boolean isTypeSupported;
    private String declaredTypeAdapterId;
    private String dataPath;
    private boolean hasChanged;

    public DataField(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = this.getAssociatedVariable().getValue().getVariables();
            this.name = DebugVariableUtils.extractAsString("name", subVariables);
            this.typeName = DebugVariableUtils.extractAsString("typeName", subVariables);
            this.evaluatedValue = DebugVariableUtils.extractAsString("evaluatedValue", subVariables);
            this.isTypeSupported = DebugVariableUtils.extractAsBoolean("isTypeSupported", subVariables);
            this.hasChanged = DebugVariableUtils.extractAsBoolean("hasChanged", subVariables);
            this.declaredTypeAdapterId = DebugVariableUtils.extractAsString("declaredTypeAdapterId", subVariables);
            this.dataPath = DebugVariableUtils.extractAsString("dataPath", subVariables);
            IVariable hasChangedVariable = DebugVariableUtils.findVariable("hasChanged", subVariables);
            this.setWritebackVariable((IVariable)new JavaVariableDecorator((IJavaVariable)this.findWritebackVariable(subVariables), (IJavaVariable)hasChangedVariable, this.name));
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public DataField(String name, String typeName, Serializable dataValue, String dataId, String dataPath) {
        super(null);
        this.dataHolder = new DataHolder(typeName, dataValue);
        this.name = name;
        this.typeName = typeName;
        this.dataPath = dataPath;
        QName qname = QName.valueOf(dataId);
        IModel activeModel = ModelManagerFactory.getCurrent().findActiveModel(qname.getNamespaceURI());
        IData data = activeModel.findData(qname.getLocalPart());
        if (data.getType().getId().equals("struct")) {
            this.declaredTypeAdapterId = (String)data.getAttribute("carnot:engine:dataType");
        }
        if (PrimitivesFactory.isSupportedType(Reflect.getClassFromClassName((String)typeName))) {
            this.isTypeSupported = true;
        } else {
            this.isTypeSupported = false;
            this.evaluatedValue = Internal_Debugger_Messages.getString("MSG_VariableNotSupported");
            trace.info((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_TypeIsNotSupportedAsDataField"), typeName));
        }
        if (dataValue != null) {
            if (this.isTypeSupported) {
                if (data.getType().getId().equals("struct")) {
                    ClientXPathMap xPathMap = new ClientXPathMap(StructuredTypeRtUtils.getAllXPaths((IModel)activeModel, (String)this.declaredTypeAdapterId));
                    StructuredDataConverter converter = new StructuredDataConverter((IXPathMap)xPathMap);
                    this.evaluatedValue = converter.toString((Object)dataValue, this.dataPath);
                } else {
                    this.evaluatedValue = Reflect.convertObjectToString((Object)dataValue);
                }
            }
        } else {
            this.evaluatedValue = "";
        }
        this.hasChanged = false;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getDeclaredTypeAdapterId() {
        return this.declaredTypeAdapterId;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getValue() {
        return this.evaluatedValue;
    }

    public void setValue(String value) {
        try {
            IJavaVariable variable = (IJavaVariable)DebugVariableUtils.findVariable("evaluatedValue", this.getAssociatedVariable().getValue().getVariables());
            this.setWritebackVariable((IVariable)variable);
            if (variable.verifyValue(value)) {
                variable.setValue(value);
                this.evaluatedValue = value;
            }
        }
        catch (DebugException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean supportsValueModification() {
        return this.isTypeSupported && this.getAssociatedVariable().supportsValueModification();
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    private IVariable findWritebackVariable(IVariable[] subVariables) throws DebugException {
        IVariable dataHolderVariable = DebugVariableUtils.findVariable("dataHolder", subVariables);
        IVariable[] dataHolderSubVariables = dataHolderVariable.getValue().getVariables();
        String variableName = DebugVariableUtils.extractAsString("variableName", dataHolderSubVariables);
        return DebugVariableUtils.findVariable(variableName, dataHolderSubVariables);
    }

    public static class DataHolder {
        private Boolean theBoolean;
        private Byte theByte;
        private Short theShort;
        private Integer theInteger;
        private Long theLong;
        private Float theFloat;
        private Double theDouble;
        private Character theCharacter;
        private String theString;
        private Calendar theCalendar;
        private Date theDate;
        private Money theMoney;
        private List theList;
        private Map theMap;
        private Serializable theSerializable;
        private String typeName;
        private String variableName;

        public DataHolder(String typeName, Serializable data) {
            this.typeName = typeName;
            this.initFittingField(data);
        }

        public String getVariableName() {
            return this.variableName;
        }

        public Serializable getData() {
            return (Serializable)Reflect.getFieldValue((Object)this, (String)this.variableName);
        }

        public String getTypeName() {
            return this.typeName;
        }

        private void initFittingField(Serializable data) {
            Class<?> type;
            if (this.theSerializable == null) {
                type = Reflect.getClassFromClassName((String)this.typeName);
                trace.info((Object)("initFittingField: " + this.typeName));
                if (type == null) {
                    trace.warn((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_CannotFindClassForTypeName"), this.typeName));
                }
            } else {
                type = this.theSerializable.getClass();
            }
            if (Boolean.class.equals(type)) {
                this.theBoolean = (Boolean)data;
                this.variableName = "theBoolean";
            } else if (Byte.class.equals(type)) {
                this.theByte = (Byte)data;
                this.variableName = "theByte";
            } else if (Short.class.equals(type)) {
                this.theShort = (Short)data;
                this.variableName = "theShort";
            } else if (Integer.class.equals(type)) {
                this.theInteger = (Integer)data;
                this.variableName = "theInteger";
            } else if (Long.class.equals(type)) {
                this.theLong = (Long)data;
                this.variableName = "theLong";
            } else if (Float.class.equals(type)) {
                this.theFloat = (Float)data;
                this.variableName = "theFloat";
            } else if (Double.class.equals(type)) {
                this.theDouble = (Double)data;
                this.variableName = "theDouble";
            } else if (Character.class.equals(type)) {
                this.theCharacter = (Character)data;
                this.variableName = "theCharacter";
            } else if (String.class.equals(type)) {
                this.theString = (String)((Object)data);
                this.variableName = "theString";
            } else if (Calendar.class.equals(type)) {
                this.theCalendar = (Calendar)data;
                this.variableName = "theCalendar";
            } else if (Date.class.equals(type)) {
                this.theDate = (Date)data;
                this.variableName = "theDate";
            } else if (Money.class.equals(type)) {
                this.theMoney = (Money)data;
                this.variableName = "theMoney";
            } else if (List.class.isAssignableFrom(type)) {
                this.theList = (List)((Object)data);
                this.variableName = "theList";
            } else if (Map.class.isAssignableFrom(type)) {
                this.theMap = (Map)((Object)data);
                this.variableName = "theMap";
            } else {
                this.theSerializable = data;
                this.variableName = "theSerializable";
            }
        }
    }
}

