/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.modeling.debug.Debug_Messages;

public class DebugVariableUtils {
    private static boolean isJavaNullValue(IValue value) throws DebugException {
        IJavaValue javaValue;
        return value instanceof IJavaValue && (javaValue = (IJavaValue)value).getJavaType() == null;
    }

    public static String extractAsString(String name, IVariable[] variables) {
        block3: {
            IValue value;
            block4: {
                try {
                    value = DebugVariableUtils.findValue(name, variables);
                    if (value == null) break block3;
                    if (!DebugVariableUtils.isJavaNullValue(value)) break block4;
                    return null;
                }
                catch (DebugException e) {
                    throw new InternalException("", (Throwable)e);
                }
            }
            return value.getValueString();
        }
        return null;
    }

    public static long extractAsLong(String name, IVariable[] variables) {
        try {
            IValue value = DebugVariableUtils.findValue(name, variables);
            if (value != null) {
                return Long.parseLong(value.getValueString());
            }
            throw new InternalException(MessageFormat.format(Debug_Messages.EXP_VariableDoesNotExist, name));
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public static double extractAsDouble(String name, IVariable[] variables) {
        try {
            IValue value = DebugVariableUtils.findValue(name, variables);
            if (value != null) {
                return Double.parseDouble(value.getValueString());
            }
            throw new InternalException(MessageFormat.format(Debug_Messages.EXP_VariableDoesNotExist, name));
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public static boolean extractAsBoolean(String name, IVariable[] variables) {
        try {
            IValue value = DebugVariableUtils.findValue(name, variables);
            if (value != null) {
                return Boolean.valueOf(value.getValueString());
            }
            throw new InternalException(MessageFormat.format(Debug_Messages.EXP_VariableDoesNotExist, name));
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public static IVariable findVariable(String name, IVariable[] variables) {
        try {
            int idx = 0;
            while (idx < variables.length) {
                if (variables[idx].getName().equals(name)) {
                    return variables[idx];
                }
                ++idx;
            }
            throw new InternalException(MessageFormat.format(Debug_Messages.EXP_VariableDoesNotExist, name));
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public static IValue findValue(String name, IVariable[] variables) {
        try {
            return DebugVariableUtils.findVariable(name, variables).getValue();
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }
}

