/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.ITransition;
import org.eclipse.stardust.engine.core.runtime.beans.TransitionTokenBean;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.Highlightable;
import org.eclipse.stardust.modeling.debug.highlighting.IHighlightable;

public class TransitionTokenDigest
extends AbstractJavaTypeValue
implements IHighlightable {
    private long oid;
    private boolean isConsumed;
    private String procDefId;
    private String transitionId;

    public TransitionTokenDigest(IVariable variable) {
        super(variable);
        try {
            IVariable[] subVariables = this.getAssociatedVariable().getValue().getVariables();
            this.oid = DebugVariableUtils.extractAsLong("oid", subVariables);
            this.isConsumed = DebugVariableUtils.extractAsBoolean("isConsumed", subVariables);
            this.procDefId = DebugVariableUtils.extractAsString("procDefId", subVariables);
            this.transitionId = DebugVariableUtils.extractAsString("transitionId", subVariables);
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public TransitionTokenDigest(TransitionTokenBean transitionToken) {
        super(null);
        Assert.isNotNull((Object)transitionToken);
        this.oid = transitionToken.getOID();
        this.isConsumed = transitionToken.isConsumed();
        ITransition transition = transitionToken.getTransition();
        IModel model = transition == null ? null : (IModel)transition.getModel();
        this.transitionId = transition == null ? null : "{" + model.getId() + '}' + transition.getId();
        this.procDefId = transition == null ? null : "{" + model.getId() + '}' + transition.getProcessDefinition().getId();
    }

    public boolean isConsumed() {
        return this.isConsumed;
    }

    protected String getProcDefId() {
        return this.procDefId;
    }

    public String getTransitionId() {
        return this.transitionId;
    }

    public long getOid() {
        return this.oid;
    }

    @Override
    public String getProcessDefinitionChildId() {
        return this.getTransitionId();
    }

    @Override
    public String getProcessDefinitionId() {
        return this.getProcDefId();
    }

    public String toString() {
        return MessageFormat.format(Debug_Messages.MSG_TransitionTokenDigest_ToString, new Long(this.getOid()), this.getTransitionId());
    }

    public boolean equals(Object other) {
        boolean isEqual;
        if (this == other) {
            isEqual = true;
        } else if (!(other instanceof IHighlightable)) {
            isEqual = false;
        } else {
            IHighlightable tmp = (IHighlightable)other;
            isEqual = new Highlightable(this.getProcessDefinitionId(), this.getProcessDefinitionChildId()).equals(new Highlightable(tmp.getProcessDefinitionId(), tmp.getProcessDefinitionChildId()));
        }
        return isEqual;
    }

    public int hashCode() {
        return new Highlightable(this.getProcessDefinitionId(), this.getProcessDefinitionChildId()).hashCode();
    }
}

