/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.eclipse.stardust.common.Action;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.runtime.TimeoutException;
import org.eclipse.stardust.engine.core.runtime.beans.ActionCarrier;
import org.eclipse.stardust.engine.core.runtime.beans.ActivityInstanceBean;
import org.eclipse.stardust.engine.core.runtime.beans.ActivityThread;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.engine.core.runtime.beans.IProcessInstance;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.engine.core.runtime.beans.ProcessInstanceBean;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;

public final class ActivityThreadCarrier
extends ActionCarrier {
    private static final long serialVersionUID = 1L;
    public static final Logger trace = LogManager.getLogger(ActivityThreadCarrier.class);
    public static final String PROCESS_INSTANCE_OID_TAG = "processInstanceOID";
    public static final String ACTIVITY_OID_TAG = "activityOID";
    public static final String ACTIVITY_INSTANCE_OID_TAG = "activityInstanceOID";
    public static final String USER_OID_TAG = "userOID";
    public static final String TIMEOUT_NOTIFICATION = "timeoutNotification";
    private long processInstanceOID;
    private long activityOID;
    private IActivityInstance activityInstance;
    private boolean timeout;
    private Map data = Collections.EMPTY_MAP;

    public ActivityThreadCarrier() {
        super(1);
    }

    public void setProcessInstance(IProcessInstance processInstance) {
        this.processInstanceOID = processInstance != null ? processInstance.getOID() : 0L;
    }

    public void setActivity(IActivity activity) {
        this.activityOID = activity != null ? activity.getOID() : 0L;
    }

    public void setActivityInstance(IActivityInstance activityInstance) {
        this.activityInstance = activityInstance;
    }

    public void setTimeout(Throwable timeout) {
        this.timeout = timeout != null;
    }

    public void doFillMessage(Message message) throws JMSException {
    }

    public void doExtract(Message message) throws JMSException {
    }

    public Action doCreateAction() {
        trace.debug((Object)("activityinstance: " + this.getActivityInstanceOid()));
        trace.debug((Object)("processinstance : " + this.processInstanceOID));
        TimeoutException timeoutException = null;
        if (this.timeout) {
            timeoutException = new TimeoutException("");
        }
        return new ActivityThreadRunner(this.processInstanceOID, this.activityOID, this.getActivityInstanceOid(), timeoutException, this.data);
    }

    public void setData(Map data) {
        this.data = data;
    }

    public String toString() {
        return MessageFormat.format(Internal_Debugger_Messages.getString("MSG_ActivityThreadCarrier"), this.processInstanceOID, this.getActivityInstanceOid(), this.activityOID);
    }

    private long getActivityInstanceOid() {
        return this.activityInstance == null ? 0L : this.activityInstance.getOID();
    }

    class ActivityThreadRunner
    implements Action {
        private Map data;
        private long processInstanceOID;
        private long activityOID;
        private long activityInstanceOID;
        private TimeoutException timeoutException;

        public ActivityThreadRunner(long processInstanceOID, long activityOID, long activityInstanceOID, TimeoutException timeoutException, Map data) {
            this.processInstanceOID = processInstanceOID;
            this.activityOID = activityOID;
            this.activityInstanceOID = activityInstanceOID;
            this.timeoutException = timeoutException;
            this.data = data;
        }

        public Object execute() {
            ProcessInstanceBean processInstance = null;
            IActivity activity = null;
            ActivityInstanceBean activityInstance = null;
            if (0L != this.activityInstanceOID) {
                activityInstance = ActivityInstanceBean.findByOID((long)this.activityInstanceOID);
                activityInstance.activate();
            } else {
                processInstance = ProcessInstanceBean.findByOID((long)this.processInstanceOID);
                activity = (IActivity)ModelManagerFactory.getCurrent().lookupObjectByOID(this.activityOID);
            }
            ActivityThread at = new ActivityThread((IProcessInstance)processInstance, activity, (IActivityInstance)activityInstance, (Exception)this.timeoutException, this.data, false);
            at.run();
            return null;
        }

        public String toString() {
            return MessageFormat.format(Internal_Debugger_Messages.getString("MSG_ActivityThread"), this.processInstanceOID, this.activityInstanceOID, this.activityOID);
        }
    }
}

