/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.config.ParametersFacade;
import org.eclipse.stardust.engine.core.runtime.beans.ActionCarrier;
import org.eclipse.stardust.engine.core.runtime.beans.ActivityThreadCarrier;
import org.eclipse.stardust.engine.core.runtime.beans.ForkingService;
import org.eclipse.stardust.engine.core.runtime.beans.ForkingServiceFactory;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.SecurityProperties;
import org.eclipse.stardust.engine.core.runtime.interceptor.MethodInterceptor;
import org.eclipse.stardust.engine.core.runtime.interceptor.MethodInvocation;
import org.eclipse.stardust.modeling.debug.engine.ManagedRunner;

public class DebugForkingInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = 1L;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ArrayList forkList = new ArrayList(5);
        HashMap locals = new HashMap();
        locals.put("Engine.ForkList", forkList);
        ParametersFacade.pushLayer(locals);
        try {
            Object result = invocation.proceed();
            if (!forkList.isEmpty()) {
                for (ActionCarrier order : forkList) {
                    ForkingServiceFactory factory = (ForkingServiceFactory)invocation.getParameters().get("Engine.ForkingServiceHome");
                    ForkingService service = factory.get();
                    boolean isActivityThread = order instanceof ActivityThreadCarrier;
                    ManagedRunner runnable = new ManagedRunner(SecurityProperties.getUser(), order.createAction(), service, isActivityThread);
                    ThreadGroup group = (ThreadGroup)Parameters.instance().get(isActivityThread ? "ThreadGroup.Infinity Activity Thread" : "ThreadGroup.Infinity Helper Thread");
                    new Thread(group, runnable).start();
                }
            }
            Object object = result;
            return object;
        }
        finally {
            ParametersFacade.popLayer();
        }
    }
}

