/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.interpreter;

import javax.swing.ImageIcon;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.modeling.debug.interpreter.Data;
import org.eclipse.stardust.modeling.debug.interpreter.MetadataPropertyHolder;

public class Column
extends MetadataPropertyHolder {
    private static ImageIcon icon;
    private Class type;
    private boolean mandatory;
    private boolean readonly;
    private String label;
    private String toolTip;

    public Column(Class type, String label, boolean mandatory, boolean readonly, String toolTip) {
        this.type = type;
        this.mandatory = mandatory;
        this.readonly = readonly;
        this.label = label;
        this.toolTip = toolTip;
    }

    public Class getType() {
        return this.type;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public String getLabel() {
        return this.label;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<COLUMN");
        buffer.append(" id=\"");
        buffer.append("12");
        buffer.append("\"");
        buffer.append(" type=\"");
        buffer.append("" + this.getType());
        buffer.append("\"");
        if (this.getLabel() != null) {
            buffer.append(" label=\"");
            buffer.append(this.getLabel());
            buffer.append("\"");
        }
        buffer.append(" mandatory=\"");
        buffer.append("" + this.getMandatory());
        buffer.append("\"");
        buffer.append(" readonly=\"");
        buffer.append("" + this.getReadonly());
        buffer.append("\"");
        if (this.getToolTip() != null) {
            buffer.append(" tooltip=\"");
            buffer.append(this.getToolTip());
            buffer.append("\"");
        }
        buffer.append(">\n");
        buffer.append("</COLUMN>\n");
        return buffer.toString();
    }

    public ImageIcon getIcon() {
        if (icon == null) {
            try {
                icon = new ImageIcon(Data.class.getResource("images/column.gif"));
            }
            catch (Exception exception) {
                throw new PublicException("Cannnot load resource \"images/column.gif\"");
            }
        }
        return icon;
    }
}

