/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.debug.debugger.Debugger;

public class LaunchConfigUtils {
    private static String trimToNull(String value) {
        String trimmedValue = value.trim();
        if (trimmedValue.length() == 0) {
            trimmedValue = null;
        }
        return trimmedValue;
    }

    public static String getModelFileName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_MODEL_FILE", null);
    }

    public static void setModelFileName(ILaunchConfigurationWorkingCopy configuration, String modelFileName) {
        configuration.setAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_MODEL_FILE", LaunchConfigUtils.trimToNull(modelFileName));
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    public static void setProjectName(ILaunchConfigurationWorkingCopy configuration, String modelFileName) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, LaunchConfigUtils.trimToNull(modelFileName));
    }

    public static String getProcessDefinitionId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_PROCESS_DEFINITION_ID", null);
    }

    public static void setProcessDefinitionId(ILaunchConfigurationWorkingCopy configuration, String modelFileName) {
        configuration.setAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_PROCESS_DEFINITION_ID", LaunchConfigUtils.trimToNull(modelFileName));
    }

    public static void setProgramArguments(ILaunchConfigurationWorkingCopy configuration, String project, String modelFile, String processDefinitionId) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, MessageFormat.format("\"{0}{1}\" \"{2}{3}\"", "model_file=", WorkspaceUtils.resolveAbsolutePath((String)LaunchConfigUtils.trimToNull(project), (String)LaunchConfigUtils.trimToNull(modelFile)), "procdef_id=", LaunchConfigUtils.trimToNull(processDefinitionId)));
    }

    private LaunchConfigUtils() {
    }

    public static void setDefaultAttributes(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, Debugger.class.getName());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.stardust.modeling.debug.launching.RuntimeClasspathProvider");
        try {
            if (configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null) == null) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Dcarnot.log.type=stdout");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getDependencies(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_MODEL_DEP", null);
    }

    public static void setDependencies(ILaunchConfigurationWorkingCopy wc, List<String> dependencies) {
        if (dependencies == null) {
            wc.removeAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_MODEL_DEP");
        } else {
            wc.setAttribute("org.eclipse.stardust.modeling.debug.ATTR_CWM_MODEL_DEP", dependencies);
        }
    }
}

