/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.launching;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.Debugger;
import org.eclipse.stardust.modeling.debug.debugger.UiAccessor;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.TransitionTokenDigest;
import org.eclipse.stardust.modeling.debug.engine.ManagedRunnerHelper;
import org.eclipse.stardust.modeling.debug.highlighting.HighlightManager;
import org.eclipse.stardust.modeling.debug.launching.LaunchConfigUtils;
import org.eclipse.stardust.modeling.debug.model.CWMDebugTarget;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.progress.UIJob;

public class LaunchDelegate
extends JavaLaunchDelegate {
    private static void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.debug", 0, message, e));
    }

    private static void validate(ILaunchConfiguration configuration) throws CoreException {
        String procDef;
        String modelFile;
        IFile file;
        String projectName = LaunchConfigUtils.getProjectName(configuration);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            LaunchDelegate.abort(MessageFormat.format(Debug_Messages.MSG_ProjectDoesNotExist, projectName), null);
        }
        if (!(file = project.getFile((IPath)new Path(modelFile = LaunchConfigUtils.getModelFileName(configuration)))).exists()) {
            LaunchDelegate.abort(MessageFormat.format(Debug_Messages.MSG_ModelFileDoesNotExist, file.getFullPath().toString()), null);
        }
        UiAccessor.loadModel(file, true);
        if (!UiAccessor.isModelLoaded(file)) {
            LaunchDelegate.abort(MessageFormat.format(Debug_Messages.MSG_ModelFileNeedsToBeLoaded, file.getFullPath().toString()), null);
        }
        if (StringUtils.isEmpty((String)(procDef = LaunchConfigUtils.getProcessDefinitionId(configuration)))) {
            LaunchDelegate.abort(Debug_Messages.MSG_ProcessDefinitionUnspecified, null);
        }
    }

    private static ProcessDefinitionType getProcessDefinition(ILaunchConfiguration configuration) throws CoreException {
        String procDefId = LaunchConfigUtils.getProcessDefinitionId(configuration);
        Assert.isNotEmpty((String)procDefId, (String)Debug_Messages.MSG_ProcessDefIdEmpty);
        boolean found = false;
        ProcessDefinitionType processDefinition2 = null;
        IEditorPart editPart = UiAccessor.getActiveEditPart();
        if (editPart != null && editPart instanceof WorkflowModelEditor) {
            WorkflowModelEditor editor = (WorkflowModelEditor)editPart;
            ModelType model = editor.getWorkflowModel();
            EList pdList = model.getProcessDefinition();
            for (ProcessDefinitionType processDefinition2 : pdList) {
                if (!processDefinition2.getId().equals(procDefId)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new ObjectNotFoundException(MessageFormat.format(Debug_Messages.MSG_ProcessDefWithIdNotFound, procDefId));
        }
        return processDefinition2;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug")) {
            HighlightManager.getDefault();
            LaunchDelegate.validate(configuration);
            ProcessDefinitionType pd = LaunchDelegate.getProcessDefinition(configuration);
            WorkflowModelEditor editor = UiAccessor.activateDiagram(null, (DiagramType)pd.getDiagram().get(0));
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            boolean analystMode = false;
            if (editor != null) {
                int choice;
                boolean hasIssues = this.hasIssues(editor, DiagramPlugin.getViewAsPerspectiveId(null));
                boolean hasAnalystIssues = this.hasIssues(editor, "ag.carnot.workflow.modeler.businessModelingPerspective");
                if (hasIssues && !analystMode && !hasAnalystIssues) {
                    choice = this.showYesNoCancel(editor.getSite().getShell(), Debug_Messages.LaunchDelegate_WARNING, Debug_Messages.LaunchDelegate_ModelInconsistencies, Debug_Messages.LaunchDelegate_MSG_SuggestAnalystSession, true);
                    if (choice == 0) {
                        analystMode = true;
                        this.setMode(editor, analystMode);
                    } else if (2 == choice) {
                        lm.removeLaunch(launch);
                        return;
                    }
                } else if (hasIssues && 1 == (choice = this.showYesCancel(editor.getSite().getShell(), Debug_Messages.LaunchDelegate_WARNING, Debug_Messages.LaunchDelegate_ModelInconsistencies, Debug_Messages.LaunchDelegate_MSG_InconsistentModel, true))) {
                    lm.removeLaunch(launch);
                    return;
                }
            }
            IDebugTarget[] targets = lm.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                CWMDebugTarget cwmTarget;
                if (targets[i] instanceof CWMDebugTarget && !(cwmTarget = (CWMDebugTarget)targets[i]).isTerminated()) {
                    if (cwmTarget.getEditor().equals(editor)) {
                        this.showMessage(editor.getSite().getShell(), Debug_Messages.LaunchDelegate_ERROR, Debug_Messages.LaunchDelegate_CanNotLaunch, Debug_Messages.LaunchDelegate_MSG_OneSessionPerEditor, false);
                        lm.removeLaunch(launch);
                        return;
                    }
                    if (analystMode != cwmTarget.isAnalystMode()) {
                        this.showMessage(editor.getSite().getShell(), Debug_Messages.LaunchDelegate_ERROR, Debug_Messages.LaunchDelegate_CanNotLaunch, MessageFormat.format(Debug_Messages.LaunchDelegate_MSG_IncompatibleSessions, this.getModeName(analystMode), this.getModeName(cwmTarget.isAnalystMode())), false);
                        lm.removeLaunch(launch);
                        return;
                    }
                }
                ++i;
            }
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new CommunicationBreakpointInitializer());
            final boolean finalAnalystMode = analystMode;
            final ILaunchConfiguration finalConfiguration = configuration;
            ILaunchConfiguration cfg = (ILaunchConfiguration)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ILaunchConfiguration.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = method.invoke((Object)finalConfiguration, args);
                    if ("getAttribute".equals(method.getName()) && IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS.equals(args[0])) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(result);
                        sb.append(' ');
                        sb.append('\"');
                        sb.append("view=");
                        sb.append(finalAnalystMode ? "analyst" : "developer");
                        sb.append('\"');
                        List<String> deps = LaunchConfigUtils.getDependencies(finalConfiguration);
                        if (deps != null) {
                            for (String dep : deps) {
                                sb.append(' ');
                                sb.append('\"');
                                sb.append("dep_file=");
                                sb.append(dep);
                                sb.append('\"');
                            }
                        }
                        result = sb.toString();
                    }
                    return result;
                }
            });
            super.launch(cfg, mode, launch, monitor);
            IDebugTarget javaTarget = launch.getDebugTarget();
            CWMDebugTarget cwmTarget = new CWMDebugTarget(editor, javaTarget, pd, analystMode);
            cwmTarget.setSourceName(LaunchConfigUtils.getModelFileName(configuration));
            launch.removeDebugTarget(javaTarget);
            launch.addDebugTarget((IDebugTarget)cwmTarget);
        }
    }

    private void setMode(final WorkflowModelEditor editor, final boolean analystMode) {
        UIJob job = new UIJob(Debug_Messages.LABEL_JOB_ChangeMode){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BpmUiActivator.getDefault().setAnalystMode(editor.getSite().getPage(), analystMode);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private String getModeName(boolean analystMode) {
        return analystMode ? Debug_Messages.LaunchDelegate_MODE_Analyst : Debug_Messages.LaunchDelegate_MODE_Developer;
    }

    private boolean hasIssues(WorkflowModelEditor editor, String perspective) {
        ValidationJob job = new ValidationJob(perspective, editor.getWorkflowModel());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        boolean hasIssues = job.hasIssues();
        return hasIssues;
    }

    private boolean showMessage(final Shell shell, String name, final String title, final String message, final boolean confirm) {
        final boolean[] result = new boolean[]{true};
        UIJob job = new UIJob(name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (confirm) {
                    result[0] = MessageDialog.openConfirm((Shell)shell, (String)title, (String)message);
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    private int showYesNoCancel(final Shell shell, String name, final String title, final String message, final boolean confirm) {
        final int[] result = new int[1];
        UIJob job = new UIJob(name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (confirm) {
                    MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    result[0] = dialog.open();
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    private int showYesCancel(final Shell shell, String name, final String title, final String message, final boolean confirm) {
        final int[] result = new int[1];
        UIJob job = new UIJob(name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (confirm) {
                    MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    result[0] = dialog.open();
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    private static class CommunicationBreakpointInitializer
    implements IDebugEventSetListener {
        private CommunicationBreakpointInitializer() {
        }

        private static IJavaMethodBreakpoint createBreakpoint(IDebugTarget target, IResource resource, Class type, String methodName, String signature) throws CoreException {
            IJavaMethodBreakpoint bp = JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)type.getName(), (String)methodName, (String)signature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)false, null);
            bp.setPersisted(false);
            target.breakpointAdded((IBreakpoint)bp);
            return bp;
        }

        private String jniVoidSignature() {
            return "V";
        }

        private String jniSignature(Class type) {
            if (type == null) {
                return this.jniVoidSignature();
            }
            StringBuffer signature = new StringBuffer();
            if (type.isArray()) {
                signature.append('[');
            }
            if (Boolean.TYPE.equals(type)) {
                signature.append('Z');
            } else if (Byte.TYPE.equals(type)) {
                signature.append('B');
            } else if (Character.TYPE.equals(type)) {
                signature.append('C');
            } else if (Double.TYPE.equals(type)) {
                signature.append('D');
            } else if (Float.TYPE.equals(type)) {
                signature.append('F');
            } else if (Integer.TYPE.equals(type)) {
                signature.append('I');
            } else if (Long.TYPE.equals(type)) {
                signature.append('J');
            } else if (Short.TYPE.equals(type)) {
                signature.append('S');
            } else {
                signature.append('L').append(StringUtils.replace((String)type.getName(), (String)".", (String)"/")).append(';');
            }
            return signature.toString();
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                ILaunchConfiguration configuration;
                IJavaDebugTarget target;
                ILaunch launch;
                DebugEvent event = events[i];
                if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget && (launch = (target = (IJavaDebugTarget)event.getSource()).getLaunch()) != null && (configuration = launch.getLaunchConfiguration()) != null) {
                    try {
                        IDebugTarget javaTarget = launch.getDebugTarget();
                        String project = LaunchConfigUtils.getProjectName(configuration);
                        String modelFile = LaunchConfigUtils.getModelFileName(configuration);
                        IResource modelResource = ResourcesPlugin.getWorkspace().getRoot().getProject(project).findMember(modelFile);
                        String signature = MessageFormat.format("({0}){1}", this.jniSignature(TransitionTokenDigest.class), this.jniVoidSignature());
                        CommunicationBreakpointInitializer.createBreakpoint(javaTarget, modelResource, Debugger.WorkflowEventListenerImpl.class, Debugger.WorkflowEventListenerImpl.performedTransitionMethodName, signature);
                        signature = MessageFormat.format("({0}){1}", this.jniSignature(ActivityInstanceDigest.class), this.jniVoidSignature());
                        CommunicationBreakpointInitializer.createBreakpoint(javaTarget, modelResource, Debugger.WorkflowEventListenerImpl.class, Debugger.WorkflowEventListenerImpl.startedActivityInstanceMethodName, signature);
                        CommunicationBreakpointInitializer.createBreakpoint(javaTarget, modelResource, Debugger.WorkflowEventListenerImpl.class, Debugger.WorkflowEventListenerImpl.completedActivityInstanceMethodName, signature);
                        signature = MessageFormat.format("(){0}", this.jniVoidSignature());
                        CommunicationBreakpointInitializer.createBreakpoint(javaTarget, modelResource, ManagedRunnerHelper.class, ManagedRunnerHelper.suspendThreadMethodName, signature);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
    }

    private static class ValidationJob
    extends Job {
        private Map filters = new HashMap();
        private ModelType model;
        private Issue[] issues;

        public ValidationJob(String perspectiveId, ModelType model) {
            super(Diagram_Messages.TXT_WorkflowModelValidation);
            this.model = model;
            if (perspectiveId != null) {
                this.filters.put("perspectiveType", perspectiveId);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            ValidationService vs = ValidationService.getInstance();
            try {
                ValidatorRegistry.setFilters((Map)this.filters);
                vs.setProgressMonitor(monitor);
                this.issues = vs.validateModel(this.model);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                ValidatorRegistry.setFilters(null);
                vs.setProgressMonitor(null);
            }
            return Status.OK_STATUS;
        }

        public boolean hasIssues() {
            return this.issues != null && this.issues.length > 0;
        }
    }
}

