/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.UiAccessor;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.ApplicationDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.NamedValue;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.model.CWMDebugElement;
import org.eclipse.stardust.modeling.debug.model.CWMDebugTarget;
import org.eclipse.stardust.modeling.debug.model.CWMStackFrame;
import org.eclipse.stardust.modeling.debug.util.CollectionUtils;

public class CWMThread
extends CWMDebugElement
implements IThread {
    private static final Logger trace = LogManager.getLogger(CWMThread.class);
    private IBreakpoint[] breakpoints;
    private IThread javaThread;
    private ActivityInstanceDigest currentActivityInstance;
    private ProcessInstanceDigest rootProcessInstance;
    private boolean isCompletionThread = false;
    private IVariable reloadValuesVariable = null;

    public CWMThread(CWMDebugTarget target, IThread javaThread) {
        this(target, javaThread, false);
    }

    public CWMThread(CWMDebugTarget target, IThread javaThread, boolean isCompletionThread) {
        super(target);
        this.javaThread = javaThread;
        this.isCompletionThread = isCompletionThread;
        this.currentActivityInstance = null;
        trace.info((Object)MessageFormat.format(Debug_Messages.CWMThread_MSG_CreateNewWorkflowThread, new Object[]{this, javaThread}));
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        ArrayList<CWMStackFrame> frameList = new ArrayList<CWMStackFrame>();
        List<IStackFrame> javaFrameList = Arrays.asList(this.javaThread.getStackFrames());
        final int maxFrameDepth = this.getMaxJavaFrameDepth();
        if (this.isCompletionThread()) {
            IStackFrame javaStackFrame = javaFrameList.size() != 0 ? javaFrameList.get(maxFrameDepth + 1) : null;
            frameList.add(new CWMStackFrame(this, this.rootProcessInstance, javaStackFrame));
        } else {
            Predicate predicate = null;
            if (this.currentActivityInstance != null) {
                predicate = new Predicate(){
                    private int frameDepthCounter = 0;

                    public boolean accept(Object o) {
                        if (this.frameDepthCounter <= maxFrameDepth) {
                            ++this.frameDepthCounter;
                            return true;
                        }
                        return false;
                    }
                };
            }
            CollectionUtils.copy(frameList, javaFrameList, predicate);
            ActivityInstanceDigest activityInstance = this.currentActivityInstance;
            while (activityInstance != null) {
                IStackFrame javaStackFrame = javaFrameList.size() != 0 ? javaFrameList.get(maxFrameDepth + 1) : null;
                frameList.add(new CWMStackFrame(this, activityInstance, javaStackFrame));
                activityInstance = activityInstance.getProcessInstance().getStartingActivityInstance();
            }
        }
        return frameList.toArray(new IStackFrame[frameList.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        String message = this.isCompletionThread() ? (this.rootProcessInstance != null ? MessageFormat.format(Debug_Messages.CWMThread_MSG_RootProcessInstance, this.rootProcessInstance.getProcDefId()) : MessageFormat.format(Debug_Messages.CWMThread_MSG_NoRootProcessInstance, this.javaThread.getName())) : (this.currentActivityInstance != null ? MessageFormat.format(Debug_Messages.CWMThread_MSG_Activity, this.currentActivityInstance.getActivityId(), this.currentActivityInstance.getProcessDefinitionId()) : MessageFormat.format(Debug_Messages.CWMThread_MSG_NoCurrentActivity, this.javaThread.getName()));
        return message;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.javaThread.isSuspended();
    }

    public void resume() throws DebugException {
        if (this.currentActivityInstance != null) {
            UiAccessor.activateDiagramForProcess((CWMDebugTarget)this.getDebugTarget(), this.currentActivityInstance.getProcessInstance().getProcDefId());
        }
        if (!this.reloadValues() && !this.performManualApplication()) {
            return;
        }
        this.javaThread.resume();
    }

    public void suspend() throws DebugException {
        this.javaThread.suspend();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.javaThread.isStepping();
    }

    public void stepInto() throws DebugException {
        if (this.getMaxJavaFrameDepth() >= 0) {
            this.javaThread.stepInto();
        } else {
            this.javaThread.resume();
        }
    }

    public void stepOver() throws DebugException {
        if (this.getMaxJavaFrameDepth() >= 0) {
            this.javaThread.stepOver();
        } else {
            this.javaThread.resume();
        }
    }

    public void stepReturn() throws DebugException {
        if (this.getMaxJavaFrameDepth() >= 0) {
            this.javaThread.stepReturn();
        } else {
            this.javaThread.resume();
        }
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.javaThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaThread.terminate();
        this.fireTerminateEvent();
    }

    @Override
    public void fireResumeEvent(int detail) {
        super.fireResumeEvent(detail);
    }

    @Override
    public void fireSuspendEvent(int detail) {
        super.fireSuspendEvent(detail);
    }

    public ActivityInstanceDigest getCurrentActivityInstance() {
        return this.currentActivityInstance;
    }

    public void setCurrentActivityInstance(ActivityInstanceDigest currentActivityInstance) {
        trace.info((Object)MessageFormat.format(Debug_Messages.CWMThread_MSG_SetCurrentActivityInstance, new Object[]{currentActivityInstance, this}));
        this.currentActivityInstance = currentActivityInstance;
    }

    public ProcessInstanceDigest getRootProcessInstance() {
        return this.rootProcessInstance;
    }

    public void setRootProcessInstance(ProcessInstanceDigest rootProcessInstance) {
        this.rootProcessInstance = rootProcessInstance;
    }

    public boolean isCompletionThread() {
        return this.isCompletionThread;
    }

    public IVariable getReloadValuesVariable() {
        return this.reloadValuesVariable;
    }

    public void setReloadValuesVariable(IVariable reloadValues) {
        this.reloadValuesVariable = reloadValues;
    }

    public IThread getJavaThread() {
        return this.javaThread;
    }

    private boolean reloadValues() {
        try {
            if (this.reloadValuesVariable != null) {
                return Boolean.valueOf(this.reloadValuesVariable.getValue().getValueString());
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return false;
    }

    private int getMaxJavaFrameDepth() {
        ApplicationDigest application;
        int maxFrameDepth = -1;
        ApplicationDigest applicationDigest = application = this.currentActivityInstance != null ? this.currentActivityInstance.getApplication() : null;
        if (application != null && !this.isCompletionThread()) {
            NamedValue[] properties = application.getProperties();
            String entryTypeName = null;
            int idx = 0;
            while (idx < properties.length) {
                if ("carnot:engine:className".equals(properties[idx].getName())) {
                    entryTypeName = properties[idx].getValue();
                    break;
                }
                ++idx;
            }
            if (StringUtils.isEmpty(entryTypeName)) {
                return maxFrameDepth;
            }
            try {
                IStackFrame[] javaStackFrames = this.javaThread.getStackFrames();
                int idx2 = javaStackFrames.length - 1;
                while (idx2 > -1) {
                    IJavaStackFrame javaStackFrame = (IJavaStackFrame)javaStackFrames[idx2];
                    if (javaStackFrame.getDeclaringTypeName().equals(entryTypeName)) {
                        maxFrameDepth = idx2;
                        break;
                    }
                    --idx2;
                }
            }
            catch (DebugException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return maxFrameDepth;
    }

    private boolean performManualApplication() throws DebugException {
        if (this.currentActivityInstance != null && ActivityInstanceDigest.IMPL_TYPE_MANUAL.equals(this.currentActivityInstance.getImplementationTypeId())) {
            DataMappingDigest[] dataMappings = this.currentActivityInstance.getDataMappings();
            ArrayList<DataMappingDigest> dataMappingVariables = new ArrayList<DataMappingDigest>();
            int idx = 0;
            while (idx < dataMappings.length) {
                dataMappingVariables.add(dataMappings[idx]);
                ++idx;
            }
            int result = UiAccessor.openManualActivityDialog(this.currentActivityInstance, dataMappingVariables.toArray(new DataMappingDigest[dataMappingVariables.size()]));
            if (1 == result) {
                return false;
            }
        }
        return true;
    }
}

