/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.DataField;
import org.eclipse.stardust.modeling.debug.model.CWMDebugElement;
import org.eclipse.stardust.modeling.debug.model.CWMDebugTarget;
import org.eclipse.stardust.modeling.debug.model.CWMStackFrame;

public class CWMVariable
extends CWMDebugElement
implements IVariable {
    private DataField dataField = null;
    private CWMStackFrame frame;
    private boolean hasChanged = false;

    public CWMVariable(CWMStackFrame frame, DataField dataField) {
        super((CWMDebugTarget)frame.getDebugTarget());
        this.frame = frame;
        Assert.isNotNull((Object)dataField, (String)Debug_Messages.ASSERT_ValueCarrierMayNotBeNull);
        this.dataField = dataField;
    }

    public DataField getDataField() {
        return this.dataField;
    }

    public IValue getValue() throws DebugException {
        return this.dataField.getWritebackVariable().getValue();
    }

    public String getName() throws DebugException {
        return this.dataField.getName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.dataField.getTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.hasChanged;
    }

    public void setValue(String expression) throws DebugException {
        if (this.verifyValue(expression)) {
            this.dataField.setValue(expression);
            this.hasChanged = true;
            this.fireChangeEvent(512);
        }
    }

    public void setValue(IValue value) throws DebugException {
        if (this.verifyValue(value)) {
            this.setValue(value.getValueString());
        }
    }

    public boolean supportsValueModification() {
        return this.dataField.supportsValueModification();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    protected CWMStackFrame getStackFrame() {
        return this.frame;
    }
}

