/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataConverter;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.DataField;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.model.ui.DebuggerUtils;
import org.eclipse.stardust.modeling.debug.model.ui.PrimitiveDataModificationListener;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredDataModificationListener;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredDetailsPanel;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredTree;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredValue;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ControlGuiFactory {
    public static Control create(final IVariable variable, DataMappingDigest dataMappingDigest, Composite panel, final Map outValues) throws Exception {
        Class<?> mappingClass = Class.forName(dataMappingDigest.getMappedTypeName());
        if (Map.class.isAssignableFrom(mappingClass) || List.class.isAssignableFrom(mappingClass)) {
            Object rootData;
            final Composite composite = new Composite(panel, 0);
            GridData gdField = new GridData(4, 2, true, false);
            gdField.heightHint = 300;
            gdField.widthHint = 300;
            composite.setLayoutData((Object)gdField);
            composite.setLayout((Layout)new FormLayout());
            final Sash sash = new Sash(composite, 512);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(30, 0);
            sash.setLayoutData((Object)data);
            sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ((FormData)sash.getLayoutData()).left = new FormAttachment(0, event.x);
                    sash.getParent().layout();
                }
            });
            DataField dataField = dataMappingDigest.getDataField();
            final IXPathMap xPathMap = DebuggerUtils.getXPathMapOfCurrentModel(dataField.getDeclaredTypeAdapterId());
            String path = dataField.getDataPath();
            String mappingXPath = StructuredDataXPathUtils.getXPathWithoutIndexes((String)path);
            String value = dataField.getValue();
            if (StringUtils.isEmpty((String)value)) {
                rootData = StructuredDataXPathUtils.createInitialValue((IXPathMap)xPathMap, (String)mappingXPath);
            } else {
                StructuredDataConverter structuredDataConverter = new StructuredDataConverter(xPathMap);
                rootData = structuredDataConverter.toCollection(value, path, true);
            }
            final StructuredValue rootValue = new StructuredValue(rootData, xPathMap.getXPath(mappingXPath), null, xPathMap);
            StructuredTree left = new StructuredTree(composite, rootValue, xPathMap, variable.supportsValueModification());
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment((Control)sash, 0);
            left.getTree().setLayoutData((Object)data);
            left.getTree().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Tree tree = (Tree)e.widget;
                    TreeItem[] selection = tree.getSelection();
                    if (selection.length == 1) {
                        Control[] children = composite.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] instanceof ScrolledComposite) {
                                children[i].dispose();
                            }
                            ++i;
                        }
                        StructuredValue parentValue = (StructuredValue)selection[0].getData();
                        StructuredDataModificationListener modificationListener = new StructuredDataModificationListener(variable, outValues, rootValue);
                        boolean editable = variable.supportsValueModification();
                        ControlGuiFactory.createStructuredDataPanel(composite, sash, xPathMap, parentValue, modificationListener, editable);
                        composite.layout();
                    }
                }
            });
            ControlGuiFactory.createStructuredDataPanel(composite, sash, xPathMap, null, null, false);
            return composite;
        }
        Text control = new Text(panel, 2048);
        if ("java.lang.Character".equals(dataMappingDigest.getMappedTypeName())) {
            control.setTextLimit(1);
        }
        control.setText(variable.getValue().getValueString());
        if (variable.supportsValueModification()) {
            control.setEditable(true);
            control.addModifyListener((ModifyListener)new PrimitiveDataModificationListener(variable, outValues));
        } else {
            control.setEditable(false);
        }
        GridData gdField = new GridData(4, 2, true, false);
        gdField.widthHint = 300;
        control.setLayoutData((Object)gdField);
        return control;
    }

    private static void createStructuredDataPanel(Composite parent, Sash sash, IXPathMap xPathMap, StructuredValue parentValue, StructuredDataModificationListener modificationListener, boolean editable) {
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        scroller.setLayoutData((Object)data);
        StructuredDetailsPanel newDetails = new StructuredDetailsPanel((Composite)scroller, parentValue, xPathMap, modificationListener, editable);
        scroller.setContent((Control)newDetails);
        scroller.setMinSize(newDetails.computeSize(-1, -1));
    }
}

