/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.views;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.debug.DebugPlugin;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.UiAccessor;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.model.CWMDebugTarget;
import org.eclipse.stardust.modeling.debug.model.CWMThread;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class WorklistView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action resetAction;
    private Action removeEmptyPerformersAction;
    private Action activateAction;
    private Action doubleClickAction;
    public static final String VIEW_ID = "org.eclipse.stardust.modeling.debug.views.WorklistView";

    private void registerLaunchListener() {
        ILaunchManager launchManager = org.eclipse.debug.core.DebugPlugin.getDefault().getLaunchManager();
        if (launchManager != null) {
            launchManager.addLaunchListener(new ILaunchListener(){

                public void launchAdded(ILaunch launch) {
                    WorklistView.this.notifyWorklistManager(launch.getDebugTargets(), true);
                }

                public void launchChanged(ILaunch launch) {
                    WorklistView.this.notifyWorklistManager(launch.getDebugTargets(), true);
                }

                public void launchRemoved(ILaunch launch) {
                    WorklistView.this.notifyWorklistManager(launch.getDebugTargets(), false);
                }
            });
            this.notifyWorklistManager(launchManager.getDebugTargets(), true);
        }
    }

    private void notifyWorklistManager(IDebugTarget[] targets, boolean register) {
        int idx = 0;
        while (idx < targets.length) {
            if (targets[idx] instanceof CWMDebugTarget) {
                CWMDebugTarget.WorklistManager manager = ((CWMDebugTarget)targets[idx]).getWorklistManager();
                if (register) {
                    manager.addWorklistView(this);
                    break;
                }
                manager.removeWorklistView(this);
                this.reset();
                break;
            }
            ++idx;
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setAutoExpandLevel(2);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof ActivityInstanceDigest) {
                    ActivityInstanceDigest item = (ActivityInstanceDigest)selection.getFirstElement();
                    ViewContentProvider cp = (ViewContentProvider)WorklistView.this.viewer.getContentProvider();
                    if (cp.root != null) {
                        UiAccessor.activateDiagramForProcess(cp.root.getTarget(), item.getProcessDefinitionId());
                    }
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.registerLaunchListener();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorklistView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.activateAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.activateAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.activateAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.resetAction = new Action(){

            public void run() {
                WorklistView.this.viewer.setInput(null);
            }
        };
        this.resetAction.setText(Debug_Messages.BUTTON_ClearContent);
        this.resetAction.setToolTipText(Debug_Messages.TOOLTIP_ClearContent);
        this.resetAction.setImageDescriptor(DebugPlugin.getImageDescriptor("icons/full/obj16/excludeUser_action_icon.gif"));
        this.removeEmptyPerformersAction = new Action(){

            public void run() {
                WorklistView.this.viewer.refresh();
            }
        };
        this.removeEmptyPerformersAction.setText(Debug_Messages.BUTTON_ClearEmptyPerformers);
        this.removeEmptyPerformersAction.setToolTipText(Debug_Messages.TOOLTIP_ClearEmptyPerformers);
        this.removeEmptyPerformersAction.setImageDescriptor(DebugPlugin.getImageDescriptor("icons/full/obj16/excludeUser_action_icon.gif"));
        this.activateAction = new Action(){

            public void run() {
                ISelection selection = WorklistView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ActivityInstanceDigest) {
                    ActivityInstanceDigest activityInstance = (ActivityInstanceDigest)obj;
                    IThread thread = activityInstance.getThread();
                    if (thread == null || !(thread instanceof CWMThread)) {
                        WorklistView.this.showMessage(MessageFormat.format(Debug_Messages.MSG_ActivityInstanceCannotBeResumedFromWorklist, obj.toString()));
                        return;
                    }
                    try {
                        ((CWMThread)thread).resume();
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.activateAction.setText(Debug_Messages.BUTTON_ActivateFromWorklist);
        this.activateAction.setToolTipText(Debug_Messages.TOOLTIP_ActivateFromWorklist);
        this.activateAction.setImageDescriptor(DebugPlugin.getImageDescriptor("icons/full/obj16/activateActivity_action_icon.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                WorklistView.this.activateAction.run();
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WorklistView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Debug_Messages.TITLE_CARNOTWorklist, (String)message);
    }

    public void refresh(final CWMDebugTarget.WorklistManager manager) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (WorklistView.this.viewer.getInput() != manager) {
                    WorklistView.this.viewer.setInput((Object)manager);
                    WorklistView.this.viewer.expandToLevel(2);
                } else {
                    WorklistView.this.viewer.refresh();
                    WorklistView.this.viewer.expandToLevel(2);
                }
            }
        });
    }

    public void reset() {
        this.refresh(null);
    }

    private static class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private CWMDebugTarget.WorklistManager root = null;

        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.root = null;
            if (newInput instanceof CWMDebugTarget.WorklistManager) {
                this.root = (CWMDebugTarget.WorklistManager)newInput;
            }
        }

        public void dispose() {
            this.root = null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            String performer;
            Object parent = this.root;
            if (child instanceof ActivityInstanceDigest && (performer = ((ActivityInstanceDigest)child).getPerformerName()) != null) {
                parent = performer;
            }
            return parent;
        }

        public Object[] getChildren(Object parent) {
            HashSet<Object> children = new HashSet<Object>();
            Iterator i = this.root.getWorklist();
            while (i.hasNext()) {
                ActivityInstanceDigest digest = (ActivityInstanceDigest)i.next();
                if (parent == this.root) {
                    String performer = digest.getPerformerName();
                    children.add(performer == null ? digest : performer);
                    continue;
                }
                if (!(parent instanceof String) || !parent.equals(digest.getPerformerName())) continue;
                children.add(digest);
            }
            return children.toArray();
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }
    }

    private static class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof ActivityInstanceDigest) {
                return MessageFormat.format(Debug_Messages.WorklistContentFormat, ((ActivityInstanceDigest)obj).getActivityName());
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof ActivityInstanceDigest) {
                imageKey = "icons/full/obj16/activity.gif";
            } else if (obj instanceof String) {
                imageKey = "icons/full/obj16/role.gif";
            }
            return DebugPlugin.getImage(imageKey);
        }
    }
}

