/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.basic.ui;

import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.templates.basic.Templates_Basic_Messages;
import org.eclipse.stardust.modeling.templates.basic.ui.LoopTemplatePage;
import org.eclipse.stardust.modeling.templates.defaulttemplate.TemplateHelper;

public class LoopTemplateWizard
extends Wizard {
    private LoopTemplatePage newTemplatePage;
    private WorkflowModelEditor editor;
    private ModelType model;
    private DiagramType diagram;
    private ProcessDefinitionType process;
    private int xHint;
    private int yHint;
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
    private EditPart editPart;
    private TemplateHelper templateHelper;
    private XmlTextNode expression;
    private boolean killed;

    public LoopTemplateWizard() {
    }

    public LoopTemplateWizard(WorkflowModelEditor targetEditor, ModelType targetModel, DiagramType targetDiagram, EditPart editPart, int xHint, int yHint) {
        this.setWindowTitle(Templates_Basic_Messages.TXT_APPLY_LOOP_TEMPLATE);
        this.editPart = editPart;
        this.model = targetModel;
        this.editor = targetEditor;
        this.diagram = targetDiagram;
        this.process = (ProcessDefinitionType)targetDiagram.eContainer();
        this.xHint = xHint;
        this.yHint = yHint;
        if (editPart.getModel() != null && editPart.getModel() instanceof ISymbolContainer) {
            this.xHint = 5;
            this.yHint = 5;
        }
        this.templateHelper = new TemplateHelper(this.model, this.diagram, this.process, editPart);
    }

    public void addPages() {
        super.addPages();
        this.newTemplatePage = new LoopTemplatePage(Templates_Basic_Messages.TXT_LOOP_TEMPLATE, Templates_Basic_Messages.TXT_LOOP_TEMPLATE, null);
        this.addPage((IWizardPage)this.newTemplatePage);
    }

    public boolean performFinish() {
        String kind = this.newTemplatePage.getKind();
        String condition = this.newTemplatePage.getLoopCondition();
        String orientation = this.newTemplatePage.getOrientationText();
        int number = Integer.parseInt(this.newTemplatePage.getNumber());
        int x = this.xHint;
        int y = this.yHint;
        ActivityType firstActivity = null;
        ActivityType lastActivity = null;
        ActivitySymbolType lastActivitySymbol = null;
        ActivitySymbolType firstActivitySymbol = null;
        int i = 0;
        while (i < number) {
            ActivityType sequenceActivity = this.templateHelper.createActivity(String.valueOf(kind) + " " + (i + 1), kind);
            ActivitySymbolType sequenceActivitySymbol = this.templateHelper.createActivitySymbol(sequenceActivity, x, y);
            if (lastActivity != null) {
                TransitionType sequenceTransition = this.templateHelper.createTransition("Transition " + i);
                sequenceTransition.setCondition("CONDITION");
                this.expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                sequenceTransition.setExpression(this.expression);
                ModelUtils.setCDataString((FeatureMap)this.expression.getMixed(), (String)"true", (boolean)true);
                TransitionConnectionType sequenceTransitionSymbol = this.templateHelper.createTransitionSymbol(sequenceTransition);
                sequenceTransition.setFrom(lastActivity);
                sequenceTransition.setTo(sequenceActivity);
                sequenceTransitionSymbol.setSourceActivitySymbol((IFlowObjectSymbol)lastActivitySymbol);
                sequenceTransitionSymbol.setTargetActivitySymbol((IFlowObjectSymbol)sequenceActivitySymbol);
                if (orientation.equalsIgnoreCase("Vertical")) {
                    sequenceTransitionSymbol.setSourceAnchor("bottom");
                    sequenceTransitionSymbol.setTargetAnchor("top");
                } else {
                    sequenceTransitionSymbol.setSourceAnchor("right");
                    sequenceTransitionSymbol.setTargetAnchor("left");
                }
            }
            if (orientation.equalsIgnoreCase("Vertical")) {
                y += 100;
            } else {
                x += 250;
            }
            lastActivity = sequenceActivity;
            lastActivitySymbol = sequenceActivitySymbol;
            if (firstActivity == null) {
                firstActivity = sequenceActivity;
                firstActivitySymbol = sequenceActivitySymbol;
            }
            ++i;
        }
        TransitionType loopTransition = this.templateHelper.createTransition("Transition");
        loopTransition.setCondition("CONDITION");
        this.expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
        loopTransition.setExpression(this.expression);
        ModelUtils.setCDataString((FeatureMap)this.expression.getMixed(), (String)condition, (boolean)true);
        TransitionConnectionType loopTransitionSymbol = this.templateHelper.createTransitionSymbol(loopTransition);
        loopTransition.setFrom(lastActivity);
        loopTransition.setTo(firstActivity);
        loopTransitionSymbol.setSourceActivitySymbol((IFlowObjectSymbol)lastActivitySymbol);
        loopTransitionSymbol.setTargetActivitySymbol(firstActivitySymbol);
        if (orientation.equalsIgnoreCase("Vertical")) {
            loopTransitionSymbol.setSourceAnchor("right");
            loopTransitionSymbol.setTargetAnchor("right");
        } else {
            loopTransitionSymbol.setSourceAnchor("top");
            loopTransitionSymbol.setTargetAnchor("top");
        }
        return true;
    }

    public boolean isKilled() {
        return this.killed;
    }
}

