/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.modeling.transformation.debug.common.SteppingManager;
import org.eclipse.stardust.modeling.transformation.debug.debugger.RhinoDebugFrame;
import org.eclipse.stardust.modeling.transformation.debug.debugger.RhinoDebugger;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsThread;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageBreakpointManager;

public class JsDebugTarget
extends JsDebugElement
implements IDebugTarget {
    private static final Logger trace = LogManager.getLogger(JsDebugTarget.class);
    private final ILaunch launch;
    private final RhinoDebugger jsDebugger;
    private boolean isTerminated = false;
    private boolean isSuspended = false;
    private String sourceName;
    private JsThread thread = null;
    private ApplicationType applicationType;
    private String fieldPath;
    private IProject project;
    private SteppingManager steppingManager = new SteppingManager();
    private MessageBreakpointManager breakpointManager;

    public JsDebugTarget(ILaunch launch, RhinoDebugger jsDebugger) throws CoreException {
        super(null);
        this.target = this;
        this.launch = launch;
        this.jsDebugger = jsDebugger;
        jsDebugger.attachDebugTarget(this);
        this.breakpointManager = new MessageBreakpointManager();
    }

    public void addDebugFrame(RhinoDebugFrame debugFrame) throws DebugException {
        if (!this.hasThreads()) {
            this.thread = new JsThread(this);
        }
        this.thread.addDebugFrame(debugFrame);
    }

    public void removeDebugFrame(RhinoDebugFrame debugFrame) throws DebugException {
        if (this.hasThreads()) {
            this.thread.removeDebugFrame(debugFrame);
            if (!this.thread.hasDebugFrames()) {
                this.thread.fireTerminateEvent();
                this.thread = null;
            }
        }
    }

    public void notifyChangeInDebugFrame(RhinoDebugFrame debugFrame) throws DebugException {
        if (this.hasThreads()) {
            this.thread.notifyChangeInDebugFrame(debugFrame);
        }
    }

    public SteppingManager getSteppingManager() {
        return this.steppingManager;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    @Override
    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    @Override
    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Override
    public String getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] iThreadArray;
        if (this.hasThreads()) {
            IThread[] iThreadArray2 = new IThread[1];
            iThreadArray = iThreadArray2;
            iThreadArray2[0] = this.thread;
        } else {
            iThreadArray = new IThread[]{};
        }
        return iThreadArray;
    }

    public boolean hasThreads() throws DebugException {
        return this.hasThreadsNoThrow();
    }

    private boolean hasThreadsNoThrow() {
        return this.thread != null;
    }

    public String getName() throws DebugException {
        return "Infinity Message Transformation";
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return MessageBreakpointManager.canHandleBreakpoint((IBreakpoint)breakpoint);
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.cleanup();
        if (this.hasThreads()) {
            this.thread.terminate();
            this.thread = null;
        }
        this.isTerminated = true;
        this.fireTerminateEvent();
    }

    public boolean canResume() {
        if (this.hasThreadsNoThrow()) {
            return this.thread.canResume();
        }
        return false;
    }

    public boolean canSuspend() {
        if (this.hasThreadsNoThrow()) {
            return this.thread.canSuspend();
        }
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        if (this.hasThreadsNoThrow()) {
            this.thread.resume();
            this.fireResumeEvent(32);
        }
    }

    public void suspend() throws DebugException {
        if (this.hasThreadsNoThrow()) {
            this.thread.suspend();
            this.fireSuspendEvent(32);
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.stardust.modeling.transformation.debug", "Feature not supported."));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public MessageBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    private void cleanup() {
    }
}

