/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.javascript.AbstractStructuredDataAccessPointAdapter;
import org.eclipse.stardust.engine.core.javascript.StructuredDataListAccessor;
import org.eclipse.stardust.engine.core.javascript.StructuredDataMapAccessor;
import org.eclipse.stardust.engine.extensions.transformation.runtime.transformation.MessageTransformationScope;
import org.eclipse.stardust.modeling.transformation.debug.common.CommonConstants;
import org.eclipse.stardust.modeling.transformation.debug.debugger.RhinoDebugFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.JsExceptionVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsThread;
import org.eclipse.stardust.modeling.transformation.debug.model.JsValue;
import org.eclipse.stardust.modeling.transformation.debug.model.JsVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataListVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataMapVariable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.debug.DebuggableScript;

public class JsStackFrame
extends JsDebugElement
implements IStackFrame {
    private JsThread thread;
    private RhinoDebugFrame debugFrame;

    public JsStackFrame(JsThread thread, RhinoDebugFrame debugFrame) {
        super((JsDebugTarget)thread.getDebugTarget());
        this.thread = thread;
        this.debugFrame = debugFrame;
    }

    public RhinoDebugFrame getDebugFrame() {
        return this.debugFrame;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() {
        return (IVariable[])Context.call((ContextAction)new ContextAction(){

            public Object run(Context arg0) {
                try {
                    return JsStackFrame.this.getVariablesActionImpl();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return JsVariable.NO_VARS;
                }
            }
        });
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.debugFrame.getCurrentLine();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        String name = this.debugFrame.getDebuggableScript().getFunctionName();
        if (StringUtils.isEmpty((String)name)) {
            name = "Script entry";
        }
        name = String.valueOf(name) + " [line: " + this.getLineNumber() + "]";
        return name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    @Override
    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsStackFrame) {
            JsStackFrame stackFrame = (JsStackFrame)((Object)obj);
            try {
                return this.getDebugTarget() == stackFrame.getDebugTarget() && this.getName().equals(stackFrame.getName()) && this.getLineNumber() == stackFrame.getLineNumber();
            }
            catch (DebugException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private IVariable[] getVariablesActionImpl() throws DebugException {
        IStackFrame[] stackFrames;
        ArrayList<JsDebugElement> vars = new ArrayList<JsDebugElement>();
        if (this.debugFrame.getThisObj() != null) {
            vars.add(new JsVariable(this, null, "this", this.debugFrame.getThisObj()));
        }
        Scriptable scope = this.debugFrame.getScope();
        DebuggableScript debuggableScript = this.debugFrame.getDebuggableScript();
        if (scope != null && debuggableScript != null) {
            int i = 0;
            while (i < debuggableScript.getParamAndVarCount()) {
                String name = debuggableScript.getParamOrVarName(i);
                Object rawValue = ScriptableObject.getProperty((Scriptable)scope, (String)name);
                if (JsValue.isValidJsValue(rawValue)) {
                    if (rawValue instanceof AbstractStructuredDataAccessPointAdapter) {
                        this.addStructDataVariable(vars, name, (AbstractStructuredDataAccessPointAdapter)rawValue);
                    } else {
                        vars.add(new JsVariable(this, null, name, rawValue));
                    }
                }
                ++i;
            }
            if (scope instanceof MessageTransformationScope) {
                MessageTransformationScope mtScope = (MessageTransformationScope)scope;
                ArrayList messageAdapters = new ArrayList(mtScope.getInputMessagAdapters().keySet());
                messageAdapters.addAll(mtScope.getOutputMessagAdapters().keySet());
                for (String name : messageAdapters) {
                    AbstractStructuredDataAccessPointAdapter rawValue = (AbstractStructuredDataAccessPointAdapter)ScriptableObject.getProperty((Scriptable)scope, (String)name);
                    if (!JsValue.isValidJsValue(rawValue)) continue;
                    this.addStructDataVariable(vars, name, rawValue);
                }
            }
        }
        if (CommonConstants.NO_THROWABLE != this.thread.getSuspendedByThrowable() && this.equals((stackFrames = this.thread.getStackFrames())[0])) {
            vars.add(new JsExceptionVariable(this, this.thread.getSuspendedByThrowable()));
        }
        if (vars.size() == 0) {
            return new IVariable[0];
        }
        return vars.toArray(new IVariable[vars.size()]);
    }

    private void addStructDataVariable(List vars, String name, AbstractStructuredDataAccessPointAdapter rawValue) {
        if (rawValue instanceof StructuredDataMapAccessor) {
            vars.add(new StructuredDataMapVariable(this, null, name, (StructuredDataMapAccessor)rawValue));
        } else {
            vars.add(new StructuredDataListVariable(this, null, name, (StructuredDataListAccessor)rawValue));
        }
    }
}

