/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.stardust.engine.core.javascript.StructuredDataListAccessor;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.modeling.transformation.debug.model.AbstractVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataListValue;

public class StructuredDataListVariable
extends AbstractVariable {
    private final StructuredDataListAccessor accessor;
    private final TypedXPath typedXPath;
    private final String name;
    private final int size;
    private final JsStackFrame stackFrame;

    public StructuredDataListVariable(JsStackFrame stackFrame, AbstractVariable parent, String name, StructuredDataListAccessor accessor) {
        this(stackFrame, parent, name, accessor, accessor == null ? null : accessor.getXPath());
    }

    public StructuredDataListVariable(JsStackFrame stackFrame, AbstractVariable parent, String name, StructuredDataListAccessor accessor, TypedXPath typedXPath) {
        super(stackFrame, parent);
        this.accessor = accessor;
        this.typedXPath = typedXPath;
        this.name = name;
        if (accessor != null) {
            List list = (List)accessor.getValue();
            this.size = list.size();
        } else {
            this.size = 0;
        }
        this.stackFrame = stackFrame;
    }

    public JsStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public StructuredDataListAccessor getAccessor() {
        return this.accessor;
    }

    public TypedXPath getTypedXPath() {
        return this.typedXPath;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.accessor == null ? "null" : String.valueOf(this.getTypedXPath().getXsdTypeName()) + "[" + this.size + "]";
    }

    public IValue getValue() throws DebugException {
        return new StructuredDataListValue(this);
    }

    @Override
    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    @Override
    public boolean supportsValueModification() {
        return false;
    }
}

