/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.engine.core.javascript.ListValuedXPathAdapter;
import org.eclipse.stardust.engine.core.javascript.StructuredDataListAccessor;
import org.eclipse.stardust.engine.core.javascript.StructuredDataMapAccessor;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.modeling.transformation.debug.model.AbstractVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataListVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataMapVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.StructuredDataPrimitiveVariable;

public class StructuredDataMapValue
extends JsDebugElement
implements IValue {
    private final StructuredDataMapVariable variable;

    public StructuredDataMapValue(StructuredDataMapVariable variable) {
        super((JsDebugTarget)variable.getDebugTarget());
        this.variable = variable;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.variable.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        String localXPath;
        StructuredDataMapAccessor accessor = this.variable.getAccessor();
        Object object = accessor.get(localXPath = StructuredDataXPathUtils.getLastXPathPart((String)this.variable.getTypedXPath().getXPath()), null);
        return object == null ? this.getReferenceTypeName() : object.toString();
    }

    public IVariable[] getVariables() throws DebugException {
        ArrayList<AbstractVariable> variables = new ArrayList<AbstractVariable>();
        TypedXPath typedXPath = this.variable.getTypedXPath();
        StructuredDataMapAccessor accessor = this.variable.getAccessor();
        for (TypedXPath child : typedXPath.getChildXPaths()) {
            if (child instanceof ListValuedXPathAdapter) continue;
            String name = StructuredDataXPathUtils.getLastXPathPart((String)child.getXPath());
            Object object = accessor.get(name, null);
            if (object instanceof StructuredDataListAccessor) {
                StructuredDataListAccessor listAccessor = (StructuredDataListAccessor)object;
                variables.add(new StructuredDataListVariable(this.variable.getStackFrame(), this.variable, name, listAccessor, child));
                continue;
            }
            if (object instanceof StructuredDataMapAccessor) {
                StructuredDataMapAccessor mapAccessor = (StructuredDataMapAccessor)object;
                variables.add(new StructuredDataMapVariable(this.variable.getStackFrame(), this.variable, name, mapAccessor, child));
                continue;
            }
            variables.add(new StructuredDataPrimitiveVariable(this.variable.getStackFrame(), this.variable, name, accessor, child));
        }
        return variables.isEmpty() ? new IVariable[]{} : variables.toArray(new IVariable[variables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }
}

