/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.validation.Issue;

public class ValidationMarkerService {
    private static AtomicReference<ValidationMarkerService> service = new AtomicReference();
    private final Map<IResource, Map<Long, Issue>> markerMappingRegistry = CollectionUtils.newMap();

    public static ValidationMarkerService getInstance() {
        if (service.get() == null) {
            service.compareAndSet(null, new ValidationMarkerService());
        }
        return service.get();
    }

    public void createMapping(IMarker marker, Issue issue) {
        try {
            if ("org.eclipse.stardust.modeling.validation.wfModelValidationMarker".equals(marker.getType())) {
                Map mapping = this.markerMappingRegistry.get(marker.getResource());
                if (mapping == null) {
                    mapping = CollectionUtils.newMap();
                    this.markerMappingRegistry.put(marker.getResource(), mapping);
                }
                mapping.put(marker.getId(), issue);
            }
        }
        catch (CoreException coreException) {}
    }

    public Issue resolveMapping(IMarker marker) {
        Issue issue = null;
        try {
            if ("org.eclipse.stardust.modeling.validation.wfModelValidationMarker".equals(marker.getType())) {
                issue = this.resolveMapping(marker.getResource(), marker.getId());
            }
        }
        catch (CoreException coreException) {}
        return issue;
    }

    public Issue resolveMapping(IResource resource, long markerId) {
        Map<Long, Issue> mapping = this.markerMappingRegistry.get(resource);
        return mapping == null ? null : mapping.get(markerId);
    }

    public void removeMapping(IMarker marker) {
        try {
            if ("org.eclipse.stardust.modeling.validation.wfModelValidationMarker".equals(marker.getType())) {
                this.removeMapping(marker.getResource(), marker.getId());
            }
        }
        catch (CoreException coreException) {}
    }

    public void removeMapping(IResource resource, long markerId) {
        Map<Long, Issue> mapping = this.markerMappingRegistry.get(resource);
        if (mapping != null) {
            mapping.remove(markerId);
        }
    }

    public void removeMappings(IResource resource) {
        Map<Long, Issue> mapping = this.markerMappingRegistry.get(resource);
        if (mapping != null) {
            mapping.clear();
        }
    }

    private ValidationMarkerService() {
    }
}

