/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import org.eclipse.jdt.core.Signature;
import org.eclipse.stardust.common.StringUtils;

public class MethodInfo {
    private String label;
    private String encoded;
    private boolean constructor;
    private final boolean isAccessible;
    private boolean usedForObjectCreation;
    private String[] paramNames;
    private String returnName;
    private String[] parameterTypes;
    private String returnType;
    private boolean hasReturn;
    private boolean isPrimitiveReturn;
    private boolean isArrayReturn;
    private String[] paramLabels;

    public MethodInfo(boolean constructor, char[] name, char[] signature, boolean isAccessible) {
        this(constructor, new String(name), MethodInfo.getParameterSignatures(signature), MethodInfo.getParameterTypes(signature), null, MethodInfo.getReturnSignature(signature), MethodInfo.getReturnType(signature), isAccessible);
    }

    private static String getReturnType(char[] signature) {
        char[] result = Signature.getReturnType((char[])signature);
        return new String(Signature.toString((String)new String(result)));
    }

    private static String getReturnSignature(char[] signature) {
        char[] result = Signature.getReturnType((char[])signature);
        return new String(result);
    }

    private static String[] getParameterTypes(char[] signature) {
        char[][] params = Signature.getParameterTypes((char[])signature);
        String[] types = new String[params.length];
        int i = 0;
        while (i < types.length) {
            types[i] = new String(Signature.toString((String)new String(params[i])));
            ++i;
        }
        return types;
    }

    private static String[] getParameterSignatures(char[] signature) {
        char[][] params = Signature.getParameterTypes((char[])signature);
        String[] signatures = new String[params.length];
        int i = 0;
        while (i < signatures.length) {
            signatures[i] = new String(params[i]);
            ++i;
        }
        return signatures;
    }

    public MethodInfo(boolean constructor, String name, String[] parameterSignatures, String[] parameterTypes, String[] parameterLabels, String returnSignature, String returnType, boolean isAccessible) {
        this.constructor = constructor;
        this.usedForObjectCreation = constructor;
        this.isAccessible = isAccessible;
        StringBuffer nameBuffer = new StringBuffer();
        StringBuffer encodedBuffer = new StringBuffer();
        nameBuffer.append(name).append('(');
        encodedBuffer.append(name).append('(');
        int i = 0;
        while (i < parameterSignatures.length) {
            if (i > 0) {
                nameBuffer.append(", ");
                encodedBuffer.append(',');
            }
            nameBuffer.append(Signature.getSignatureSimpleName((String)parameterSignatures[i]));
            encodedBuffer.append(parameterTypes[i]);
            ++i;
        }
        nameBuffer.append(")");
        encodedBuffer.append(")");
        this.label = nameBuffer.toString();
        this.encoded = encodedBuffer.toString();
        this.paramLabels = parameterLabels;
        this.paramNames = new String[parameterSignatures.length];
        i = 0;
        while (i < parameterSignatures.length) {
            this.paramNames[i] = new String(Signature.getSignatureSimpleName((String)parameterSignatures[i]));
            ++i;
        }
        this.returnName = new String(Signature.getSignatureSimpleName((String)returnSignature));
        this.hasReturn = returnSignature.length() > 1 || returnSignature.charAt(0) != 'V';
        this.isPrimitiveReturn = Signature.getTypeSignatureKind((String)returnSignature) == 2;
        this.isArrayReturn = Signature.getTypeSignatureKind((String)returnSignature) == 4;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public boolean isUsedForObjectCreation() {
        return this.usedForObjectCreation;
    }

    public void setUsedForObjectCreation(boolean usedForObjectCreation) {
        if (!this.isConstructor()) {
            this.usedForObjectCreation = usedForObjectCreation;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getEncoded() {
        return this.encoded;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public String getParameterType(int index) {
        return this.parameterTypes[index];
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public boolean isArrayReturn() {
        return this.isArrayReturn;
    }

    public boolean isPrimitiveReturn() {
        return this.isPrimitiveReturn;
    }

    public String getParameterLabel(int index) {
        return this.hasLabel(index) ? this.paramLabels[index] : this.paramNames[index];
    }

    private boolean hasLabel(int index) {
        return this.paramLabels != null && index >= 0 && index < this.paramLabels.length && !StringUtils.isEmpty((String)this.paramLabels[index]);
    }

    public String getParameterName(int index) {
        return this.paramNames[index];
    }

    public String getReturnName() {
        return this.returnName;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    public String toString() {
        return this.label;
    }
}

