/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.rd;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.PairMatcher;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.r.core.source.doc.RdDocumentContentInfo;

public class RdDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private static final char[][] BRACKETS = new char[][]{{'{', '}'}};
    protected PairMatcher fPairMatcher = new PairMatcher(BRACKETS, (DocContentSections)RdDocumentContentInfo.INSTANCE, new String[]{"__dftl_partition_content_type"}, '\\');

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        try {
            int partitionOffset;
            IRegion region;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"org.eclipse.statet.Rd", (int)offset, (boolean)true);
            String type = partition.getType();
            if ("__dftl_partition_content_type".equals(type) && (region = this.fPairMatcher.match(document, offset)) != null && region.getLength() >= 2) {
                textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                return;
            }
            partition = TextUtilities.getPartition((IDocument)document, (String)"org.eclipse.statet.Rd", (int)offset, (boolean)false);
            type = partition.getType();
            if (("Rd.Comment".equals(type) || "__rd_platform".equals(type)) && (offset == (partitionOffset = partition.getOffset()) || offset == partitionOffset + 1)) {
                textViewer.setSelectedRange(partitionOffset, partition.getLength());
                return;
            }
        }
        catch (NullPointerException | BadLocationException partition) {
            // empty catch block
        }
        IRegion region = this.getDefaultWordSelection(document, offset);
        textViewer.setSelectedRange(region.getOffset(), region.getLength());
    }

    protected IRegion getDefaultWordSelection(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isLetterOrDigit(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isLetterOrDigit(c)) break;
                ++offset;
            }
            int end = offset;
            if (start < end) {
                return new Region(start + 1, end - start - 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Region(anchor, 0);
    }
}

