/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.statet.internal.rj.servi.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class Utils {
    public static void preLoad() {
        new InfoStatus("org.eclipse.statet.rj.servi", Messages.StartNode_error_message);
    }

    public static List<String> parseArguments(@Nullable String args) {
        if (args == null) {
            return new ArrayList<String>(0);
        }
        ArgumentParser parser = new ArgumentParser(args);
        return parser.parseArguments();
    }

    public static void logInfo(String message) {
        CommonsRuntime.log((Status)new InfoStatus("org.eclipse.statet.rj.servi", message));
    }

    public static void logError(String message, Throwable e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.servi", message, e));
    }

    public static @Nullable String getProperty(Properties properties, String key, @Nullable String altKey) {
        String s = properties.getProperty(key);
        if (s == null && altKey != null) {
            s = properties.getProperty(altKey);
        }
        return s;
    }

    public static void setProperty(Properties properties, String key, @Nullable String value) {
        if (value != null) {
            properties.setProperty(key, value);
        } else {
            properties.remove(key);
        }
    }

    public static boolean isNegative(@Nullable Duration duration) {
        return duration != null && duration.isNegative();
    }

    private static boolean isSign(char c) {
        return c == '+' || c == '-';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static Duration parseDuration(String s) {
        if (!s.isEmpty() && (Utils.isSign(s.charAt(0)) ? s.length() >= 2 && Utils.isDigit(s.charAt(1)) : Utils.isDigit(s.charAt(0)))) {
            long millis = Long.parseLong(s);
            return Duration.ofMillis(millis);
        }
        return Duration.parse(s);
    }

    public static Duration parseDuration(@Nullable String s, Duration defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Utils.parseDuration(s);
    }

    public static String serDuration(Duration duration) {
        return Long.toString(duration.toMillis());
    }

    public static @Nullable Duration parseNullableDuration(String s) {
        if (s.isEmpty()) {
            return null;
        }
        if (Utils.isSign(s.charAt(0)) ? s.length() >= 2 && Utils.isDigit(s.charAt(1)) : Utils.isDigit(s.charAt(0))) {
            long millis = Long.parseLong(s);
            if (millis == -1L) {
                return null;
            }
            return Duration.ofMillis(millis);
        }
        return Duration.parse(s);
    }

    public static @Nullable Duration parseNullableDuration(@Nullable String s, Duration defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Utils.parseNullableDuration(s);
    }

    public static String serNullableDuration(@Nullable Duration duration) {
        if (duration == null) {
            return "-1";
        }
        return Long.toString(duration.toMillis());
    }

    private Utils() {
    }

    private static class ArgumentParser {
        private final String args;
        private int index = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.args = args;
        }

        public List<String> parseArguments() {
            ArrayList<String> v = new ArrayList<String>();
            this.ch = this.getNext();
            while (this.ch > 0) {
                if (Character.isWhitespace((char)this.ch)) {
                    this.ch = this.getNext();
                    continue;
                }
                if (this.ch == 34) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.parseString());
                    if (buf.length() == 0 && SystemUtils.getLocalOs() == 1) {
                        buf.append("\"\"");
                    }
                    v.add(buf.toString());
                    continue;
                }
                v.add(this.parseToken());
            }
            return v;
        }

        private int getNext() {
            if (this.index < this.args.length()) {
                return this.args.charAt(this.index++);
            }
            return -1;
        }

        private String parseString() {
            this.ch = this.getNext();
            if (this.ch == 34) {
                this.ch = this.getNext();
                return "";
            }
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    } else if (SystemUtils.getLocalOs() == 1) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (Character.isWhitespace((char)this.ch)) {
                        buf.append('\\');
                        return buf.toString();
                    }
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        } else if (SystemUtils.getLocalOs() == 1) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

