/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui.navigator;

import java.net.URI;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSymbolsOpenActionProvider
extends CommonActionProvider {
    private OpenCFileAction openCFileAction;
    private IViewPart viewPart = null;

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            this.viewPart = (IViewPart)workbenchSite.getPart();
            this.openCFileAction = new OpenCFileAction(this.viewPart.getSite().getPage());
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openCFileAction != null) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openCFileAction);
            actionBars.updateActionBars();
        }
    }

    public void updateActionBars() {
        if (this.openCFileAction != null) {
            IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
            this.openCFileAction.selectionChanged(celements);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openCFileAction != null) {
            IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
            this.openCFileAction.selectionChanged(celements);
            if (this.openCFileAction.isEnabled()) {
                menu.appendToGroup("group.open", (IAction)this.openCFileAction);
                this.fillOpenWithMenu(menu, celements);
            }
        }
    }

    private void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        IFile file;
        if (selection.size() != 1) {
            return;
        }
        if (selection.getFirstElement() instanceof SymbolsModel.DocumentSymbolWithURI) {
            file = LSPEclipseUtils.getFileHandle((URI)((SymbolsModel.DocumentSymbolWithURI)selection.getFirstElement()).uri);
            if (file == null) {
                return;
            }
        } else {
            return;
        }
        MenuManager submenu = new MenuManager(CViewMessages.OpenWithMenu_label, "group.openWith");
        submenu.add((IContributionItem)new OpenWithMenu(this.openCFileAction.getPage(), (IAdaptable)file));
        menu.insertAfter("group.openWith", (IContributionItem)submenu);
    }

    private class OpenCFileAction
    extends OpenFileAction {
        private IWorkbenchPage page;
        private SymbolsModel.DocumentSymbolWithURI fOpenElement;

        public OpenCFileAction(IWorkbenchPage page) {
            super(page);
            this.page = page;
        }

        public void run() {
            if (this.fOpenElement != null) {
                try {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)this.page, (URI)this.fOpenElement.uri, (String)"org.eclipse.cdt.lsp.CEditor", (boolean)false);
                    this.revealInEditor(part, this.fOpenElement);
                }
                catch (CoreException exc) {
                    Platform.getLog(((Object)((Object)this)).getClass()).log(exc.getStatus());
                }
            }
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            Object element;
            this.fOpenElement = null;
            if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof SymbolsModel.DocumentSymbolWithURI) {
                this.fOpenElement = (SymbolsModel.DocumentSymbolWithURI)element;
            }
            return this.fOpenElement != null || super.updateSelection(selection);
        }

        public IWorkbenchPage getPage() {
            return this.page;
        }

        private void revealInEditor(IEditorPart part, SymbolsModel.DocumentSymbolWithURI element) {
            if (element == null) {
                return;
            }
            if (part instanceof ITextEditor) {
                try {
                    Range range = element.symbol.getSelectionRange();
                    IDocument document = LSPEclipseUtils.getDocument((IEditorInput)part.getEditorInput());
                    int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                    int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
                    ((ITextEditor)part).selectAndReveal(startOffset, endOffset - startOffset);
                }
                catch (BadLocationException exc) {
                    Platform.getLog(((Object)((Object)this)).getClass()).error(exc.getMessage(), (Throwable)exc);
                }
            }
        }
    }
}

