/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ConverterInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolListMap;
import org.eclipse.core.runtime.IConfigurationElement;

public class ToolChainModificationHelper {
    private static ToolListMap createRealToToolMap(ITool[] tools, boolean ext) {
        ToolListMap lMap = new ToolListMap();
        int i = 0;
        while (i < tools.length) {
            ITool t;
            ITool tool = tools[i];
            ITool rt = ManagedBuildManager.getRealTool(tool);
            if (rt == null) {
                rt = tool;
            }
            ITool iTool = t = ext ? ManagedBuildManager.getExtensionTool(tool) : tool;
            if (t == null) {
                t = tool;
            }
            lMap.add(rt, t);
            ++i;
        }
        return lMap;
    }

    public static ToolListModificationInfo getModificationInfo(IResourceInfo rcInfo, ITool[] fromTools, ITool[] addedTools, ITool[] removedTools) {
        List<ITool> cur;
        ToolListMap addedMap = ToolChainModificationHelper.createRealToToolMap(addedTools, false);
        int i = 0;
        while (i < removedTools.length) {
            ITool removedTool = removedTools[i];
            ITool realTool = ManagedBuildManager.getRealTool(removedTool);
            if (realTool == null) {
                realTool = removedTool;
            }
            addedMap.remove(realTool, 0);
            ++i;
        }
        ToolListMap removedMap = ToolChainModificationHelper.createRealToToolMap(removedTools, false);
        int i2 = 0;
        while (i2 < addedTools.length) {
            ITool addedTool = addedTools[i2];
            ITool realTool = ManagedBuildManager.getRealTool(addedTool);
            if (realTool == null) {
                realTool = addedTool;
            }
            removedMap.remove(realTool, 0);
            ++i2;
        }
        addedMap.clearEmptyLists();
        removedMap.clearEmptyLists();
        ToolListMap curMap = ToolChainModificationHelper.createRealToToolMap(fromTools, false);
        for (ToolListMap.CollectionEntry entry : removedMap.collectionEntrySet()) {
            cur = curMap.get(entry.getKey(), false);
            List<ITool> removed = entry.getValue();
            if (cur == null) continue;
            int numToRemove = removed.size();
            int curSize = cur.size();
            if (curSize <= numToRemove) {
                curMap.removeAll(entry.getKey());
                continue;
            }
            int i3 = 0;
            while (i3 < numToRemove) {
                cur.remove(0);
                ++i3;
            }
        }
        curMap.clearEmptyLists();
        for (ToolListMap.CollectionEntry entry : addedMap.collectionEntrySet()) {
            cur = curMap.get(entry.getKey(), true);
            List<ITool> added = entry.getValue();
            int numToAdd = added.size();
            numToAdd -= cur.size();
            int i4 = 0;
            while (i4 < numToAdd) {
                cur.add(added.get(i4));
                ++i4;
            }
            if (cur.size() != 0) continue;
            curMap.removeAll(entry.getKey());
        }
        curMap.clearEmptyLists();
        ArrayList<ITool> resultingList = new ArrayList<ITool>();
        curMap.putValuesToCollection(resultingList);
        return ToolChainModificationHelper.getModificationInfo(rcInfo, fromTools, resultingList.toArray(new ITool[resultingList.size()]));
    }

    public static ToolListModificationInfo getModificationInfo(IResourceInfo rcInfo, ITool[] fromTools, ITool[] toTools) {
        ToolListMap curMap = ToolChainModificationHelper.createRealToToolMap(fromTools, false);
        ArrayList<ToolInfo> resultingList = new ArrayList<ToolInfo>();
        ArrayList<ToolInfo> addedList = new ArrayList<ToolInfo>(7);
        ArrayList<ToolInfo> remainedList = new ArrayList<ToolInfo>(7);
        ArrayList<ToolInfo> removedList = new ArrayList<ToolInfo>(7);
        ArrayList<ITool> removedToolsList = new ArrayList<ITool>(7);
        int i = 0;
        while (i < toTools.length) {
            ToolInfo tInfo;
            ITool remaining;
            ITool tool = toTools[i];
            Object realTool = ManagedBuildManager.getRealTool(tool);
            if (realTool == null) {
                realTool = tool;
            }
            if ((remaining = curMap.remove((ITool)realTool, 0)) != null) {
                tInfo = new ToolInfo(rcInfo, remaining, 4);
                remainedList.add(tInfo);
            } else {
                tInfo = new ToolInfo(rcInfo, tool, 1);
                addedList.add(tInfo);
            }
            resultingList.add(tInfo);
            ++i;
        }
        curMap.valuesToCollection(removedToolsList);
        for (ITool t : removedToolsList) {
            removedList.add(new ToolInfo(rcInfo, t, 2));
        }
        ToolInfo[] added = ToolChainModificationHelper.listToArray(addedList);
        ToolInfo[] removed = ToolChainModificationHelper.listToArray(removedList);
        ToolChainModificationHelper.adjustAddedList(added, removed);
        ToolChainModificationHelper.calculateConverterTools(rcInfo, removed, added, null, null);
        return new ToolListModificationInfo(rcInfo, ToolChainModificationHelper.listToArray(resultingList), added, removed, ToolChainModificationHelper.listToArray(remainedList));
    }

    private static ITool getCommonSuperClass(ITool tool1, ITool tool2) {
        int i = 0;
        while (tool2 != null) {
            if (ToolChainModificationHelper.getSuperClassLevel(tool1, tool2) != -1) {
                return tool2;
            }
            tool2 = tool2.getSuperClass();
            ++i;
        }
        return null;
    }

    private static int getSuperClassLevel(ITool tool, ITool superClass) {
        int i = 0;
        while (tool != null) {
            if (superClass == tool) {
                return i;
            }
            tool = tool.getSuperClass();
            ++i;
        }
        return -1;
    }

    private static int getLevel(ITool tool) {
        int i = 0;
        while (tool != null) {
            tool = tool.getSuperClass();
            ++i;
        }
        return i;
    }

    private static ITool getBestMatchTool(ITool realTool, ToolInfo[] tools) {
        int num = -1;
        ITool bestMatch = null;
        ITool[] identicTools = ManagedBuildManager.findIdenticalTools(realTool);
        int i = 0;
        while (i < tools.length) {
            ITool extTool = ManagedBuildManager.getExtensionTool(tools[i].getInitialTool());
            int k = 0;
            while (k < identicTools.length) {
                int level;
                ITool identic = identicTools[k];
                ITool commonSuper = ToolChainModificationHelper.getCommonSuperClass(extTool, identic);
                if (commonSuper != null && (level = ToolChainModificationHelper.getLevel(commonSuper)) > num) {
                    bestMatch = identic;
                    num = level;
                }
                ++k;
            }
            ++i;
        }
        return bestMatch;
    }

    private static void adjustAddedList(ToolInfo[] adds, ToolInfo[] removes) {
        int i = 0;
        while (i < adds.length) {
            ToolInfo add = adds[i];
            ITool bestMatch = ToolChainModificationHelper.getBestMatchTool(add.getRealTool(), removes);
            if (bestMatch != null) {
                add.updateInitialTool(bestMatch);
            }
            ++i;
        }
    }

    private static ToolInfo[] listToArray(List<ToolInfo> list) {
        return list.toArray(new ToolInfo[list.size()]);
    }

    private static Map<ITool, ConverterInfo> calculateConverterTools(IResourceInfo rcInfo, ToolInfo[] removed, ToolInfo[] added, List<ToolInfo> remainingRemoved, List<ToolInfo> remainingAdded) {
        if (remainingAdded == null) {
            remainingAdded = new ArrayList<ToolInfo>(added.length);
        }
        if (remainingRemoved == null) {
            remainingRemoved = new ArrayList<ToolInfo>(removed.length);
        }
        remainingAdded.clear();
        remainingRemoved.clear();
        remainingAdded.addAll(Arrays.asList(added));
        remainingRemoved.addAll(Arrays.asList(removed));
        HashMap<ITool, ConverterInfo> resultMap = new HashMap<ITool, ConverterInfo>();
        Iterator<ToolInfo> rIter = remainingRemoved.iterator();
        block0: while (rIter.hasNext()) {
            Map<String, IConfigurationElement> map;
            ToolInfo rti = rIter.next();
            ITool r = rti.getInitialTool();
            if (r == null || r.getParentResourceInfo() != rcInfo || (map = ManagedBuildManager.getConversionElements(r)).size() == 0) continue;
            Iterator<ToolInfo> aIter = remainingAdded.iterator();
            while (aIter.hasNext()) {
                IConfigurationElement el;
                ToolInfo ati = aIter.next();
                ITool a = ati.getBaseTool();
                if (a == null || a.getParentResourceInfo() == rcInfo || (a = ati.getBaseExtensionTool()) == null || (el = ToolChainModificationHelper.getToolConverterElement(r, a)) == null) continue;
                ConverterInfo ci = new ConverterInfo(rcInfo, r, a, el);
                resultMap.put(r, ci);
                rIter.remove();
                aIter.remove();
                ati.setConversionInfo(rti, ci);
                rti.setConversionInfo(ati, ci);
                continue block0;
            }
        }
        return resultMap;
    }

    private static IConfigurationElement getToolConverterElement(ITool fromTool, ITool toTool) {
        return ((Tool)fromTool).getConverterModificationElement(toTool);
    }
}

