/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractEditorActionDelegate
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate,
IPartListener,
INullSelectionListener {
    private IAction fAction;
    private IWorkbenchWindow fWorkbenchWindow;
    private IWorkbenchPart fTargetPart;
    private IDebugTarget fDebugTarget = null;

    public void dispose() {
        IWorkbenchWindow win = this.getWorkbenchWindow();
        if (win != null) {
            win.getPartService().removePartListener((IPartListener)this);
            win.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWorkbenchWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
        window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.initializeDebugTarget();
        this.update();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        if (this.getWorkbenchWindow() == null) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            this.setWorkbenchWindow(window);
            if (window != null) {
                window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            }
        }
        this.setTargetPart((IWorkbenchPart)targetEditor);
        this.initializeDebugTarget();
        this.update();
    }

    public void partActivated(IWorkbenchPart part) {
        this.setTargetPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTargetPart()) {
            this.setTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public abstract void selectionChanged(IWorkbenchPart var1, ISelection var2);

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        this.update();
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart part) {
        this.fTargetPart = part;
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    protected void setDebugTarget(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        this.fWorkbenchWindow = workbenchWindow;
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            action.setEnabled(this.getDebugTarget() != null && this.getTargetPart() != null);
        }
    }

    protected abstract void initializeDebugTarget();
}

