/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.clipboard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swtchart.extensions.clipboard.IImageClipboardSupplier;

public class ImageArrayTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME_BMP = "image/bmp";
    private static final String TYPE_NAME_PNG = "image/png";
    private static final ImageArrayTransfer WINDOWS = new ImageArrayTransfer("image/bmp");
    private static final ImageArrayTransfer LINUX = new ImageArrayTransfer("image/png");
    private IImageClipboardSupplier clipboardSupplier = null;
    private String[] typeNames;
    private int[] typeIds;

    public static ImageTransfer getImageTransferWindows() {
        return ImageTransfer.getInstance();
    }

    public static ImageArrayTransfer getInstanceWindows() {
        return WINDOWS;
    }

    public static ImageArrayTransfer getInstanceLinux() {
        return LINUX;
    }

    public static ImageTransfer getImageTransferMacOS() {
        return ImageTransfer.getInstance();
    }

    public static ImageArrayTransfer getInstanceSpecific(IImageClipboardSupplier clipboardSupplier) {
        return new ImageArrayTransfer(clipboardSupplier.getTypeName(), clipboardSupplier);
    }

    private ImageArrayTransfer(String typeName) {
        this(typeName, null);
    }

    private ImageArrayTransfer(String typeName, IImageClipboardSupplier clipboardSupplier) {
        this.typeNames = new String[]{typeName};
        this.typeIds = new int[]{ImageArrayTransfer.registerType((String)typeName)};
        this.clipboardSupplier = clipboardSupplier;
    }

    protected String[] getTypeNames() {
        return this.typeNames;
    }

    protected int[] getTypeIds() {
        return this.typeIds;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        block14: {
            if (this.isSupportedType(transferData)) {
                if (object instanceof ImageData) {
                    ImageData imageData = (ImageData)object;
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                            ImageLoader imageLoader = new ImageLoader();
                            imageLoader.data = new ImageData[]{imageData};
                            imageLoader.save((OutputStream)byteArrayOutputStream, this.getImageCode());
                            super.javaToNative((Object)byteArrayOutputStream.toByteArray(), transferData);
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (this.clipboardSupplier != null) {
                    super.javaToNative((Object)this.clipboardSupplier.getData(object), transferData);
                }
            }
        }
    }

    private int getImageCode() {
        String typeName;
        return switch (typeName = this.typeNames[0]) {
            case TYPE_NAME_BMP -> 0;
            case TYPE_NAME_PNG -> 5;
            default -> 4;
        };
    }
}

