/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.corext.util.Messages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableCModelAction(Shell shell, Object element) {
        return false;
    }

    public static boolean isProcessable(CEditor editor) {
        if (editor == null) {
            return true;
        }
        Shell shell = editor.getSite().getShell();
        ICElement input = SelectionConverter.getInput(editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof ICElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((ICElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(ICElement element) {
        if (element.getElementType() == 11) {
            return true;
        }
        return true;
    }

    public static boolean isEditable(CEditor editor, Shell shell, ICElement element) {
        if (editor != null) {
            ICElement input = SelectionConverter.getInput(editor);
            if (input != null && input.equals(element.getAncestor(60))) {
                return ActionUtil.isEditable(editor);
            }
            return ActionUtil.isEditable(editor) && ActionUtil.isEditable(shell, element);
        }
        return ActionUtil.isEditable(shell, element);
    }

    public static boolean isEditable(CEditor editor) {
        if (!ActionUtil.isProcessable(editor)) {
            return false;
        }
        return editor.validateEditorInputState();
    }

    public static boolean isEditable(Shell shell, ICElement element) {
        IResource resource;
        if (!ActionUtil.isProcessable(shell, element)) {
            return false;
        }
        ICElement cu = element.getAncestor(60);
        if (cu != null && (resource = cu.getResource()) != null && resource.isDerived()) {
            String warnKey = "warn_if_input_derived";
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            if (!store.getBoolean("warn_if_input_derived")) {
                return true;
            }
            MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)ActionMessages.ActionUtil_warning_derived_title, (String)Messages.format(ActionMessages.ActionUtil_warning_derived_message, BasicElementLabels.getPathLabel(resource.getFullPath(), false)), (String)ActionMessages.ActionUtil_warning_derived_dontShowAgain, (boolean)false, null, null);
            EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !toggleDialog.getToggleState());
            return toggleDialog.getReturnCode() == 2;
        }
        return true;
    }
}

